/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.api.service;

import com.alipay.mychain.sdk.api.MychainClient;
import com.alipay.mychain.sdk.api.callback.IAsyncCallback;
import com.alipay.mychain.sdk.api.env.ClientEnv;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.api.service.task.QueryReceiptTask;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.message.MessageFactory;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.message.query.QueryTransactionReceiptRequest;
import com.alipay.mychain.sdk.message.query.QueryTransactionReceiptResponse;
import com.alipay.mychain.sdk.message.transaction.AbstractTransactionRequest;
import com.alipay.mychain.sdk.message.transaction.TransactionReceiptResponse;
import com.alipay.mychain.sdk.network.INetwork;
import com.alipay.mychain.sdk.task.TimerTaskManager;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import com.alipay.mychain.sdk.utils.ByteUtils;
import com.alipay.mychain.sdk.utils.RandomUtil;
import com.alipay.mychain.zoro.crypto.cryptoservice.CryptoService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class BaseService {
    private INetwork network;
    private ClientEnv env;
    private ILogger logger;
    private TimerTaskManager timerTaskManager;

    protected BaseService(INetwork network, TimerTaskManager timerTaskManager, ClientEnv env) {
        this.network = network;
        this.timerTaskManager = timerTaskManager;
        this.env = env;
        this.logger = this.env.getLogger();
    }

    protected boolean start(MychainClient client) {
        return true;
    }

    protected boolean stop() {
        return true;
    }

    public ClientEnv getEnv() {
        return this.env;
    }

    public INetwork getNetwork() {
        return this.network;
    }

    public void signRequest(AbstractTransactionRequest request) {
        boolean zoro;
        if (this.env == null) {
            return;
        }
        boolean bl = zoro = this.env.getZoroOption().getKeyNameList() != null && this.env.getZoroOption().getPasswordList() != null;
        if (!zoro && this.env.getSignerOption().getSigners().isEmpty()) {
            this.logger.error("signRequest, sign option is error");
            return;
        }
        if (zoro) {
            this.signRequestWithZoro(this.env.getZoroOption().getKeyNameList(), this.env.getZoroOption().getPasswordList(), request);
        } else {
            this.signRequest(this.env.getSignerOption().getSigners(), request);
        }
    }

    public void signRequestWithZoro(List<byte[]> keyNameList, List<byte[]> passwordList, AbstractTransactionRequest request) {
        if (keyNameList == null || passwordList == null || request == null) {
            this.logger.error("signRequestByZoro, parameter is invalid");
            return;
        }
        int size = keyNameList.size();
        if (size > 0 && size == passwordList.size()) {
            ArrayList<byte[]> signData = new ArrayList<byte[]>();
            byte[] txRLPData = request.getTransaction().buildData();
            for (int i = 0; i < size; ++i) {
                try {
                    byte[] result = CryptoService.getInstance().ecdsaSign(keyNameList.get(i), passwordList.get(i), txRLPData);
                    signData.add(result);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error("signRequest, zoro sign error", (Object)ExceptionUtils.getStackTrace((Throwable)e));
                    return;
                }
            }
            if (size == signData.size()) {
                request.getTransaction().setSignatureList(signData);
            }
        } else {
            this.logger.error("signRequest, zoro option is invalid");
        }
    }

    public void signRequest(List<SignerBase> signers, AbstractTransactionRequest request) {
        request.getTransaction().calcSignature(signers);
    }

    protected Response sendSyncRequest(Request request) {
        this.logger.debug("sendSyncRequest, request:{}", (Object)request.toString());
        if (!request.isValid()) {
            this.logger.error("sendSyncRequest, request parameters is invalid");
            return (Response)MessageFactory.getResponse(request, ErrorCode.SDK_INVALID_PARAMETER);
        }
        Response response = this.getNetwork().sendSyncRequest(request, new Hash(), this.env.getRequestOption().getSendRequestTimeoutMs());
        if (response == null) {
            return (Response)MessageFactory.getResponse(request, ErrorCode.SDK_INTERNAL_ERROR);
        }
        return response;
    }

    protected TransactionReceiptResponse sendSyncTransaction(AbstractTransactionRequest request) {
        this.logger.debug("sendSyncTransaction, msgType:{}", (Object)request.getMessageType().name());
        if (!request.isValid()) {
            this.logger.error("sendSyncTransaction, request parameters is invalid");
            return (TransactionReceiptResponse)MessageFactory.getResponse(request, ErrorCode.SDK_INVALID_PARAMETER);
        }
        this.complete(request);
        this.logger.debug("SendSyncTransaction:request:{}", (Object)request.toString());
        if (request.getTransaction().getSignatureList().isEmpty()) {
            this.signRequest(request);
        } else {
            this.logger.debug("sendSyncTransaction, request signature is not empty");
        }
        this.logger.info("sendSyncTransaction, txHash:" + request.getTransaction().getHash());
        TransactionReceiptResponse receiptResponse = (TransactionReceiptResponse)this.getNetwork().sendSyncRequest(request, request.getTransaction().getHash(), this.env.getRequestOption().getSendRequestTimeoutMs());
        if (receiptResponse == null) {
            return (TransactionReceiptResponse)MessageFactory.getResponse(request, ErrorCode.SDK_INTERNAL_ERROR);
        }
        this.logger.debug("sendSyncTransaction, response isSuccess :" + receiptResponse.isSuccess());
        if (!receiptResponse.getErrorCode().isSuccess()) {
            return receiptResponse;
        }
        Response response = this.queryReceiptSync(receiptResponse.getTxHash(), request.getGroupId());
        if (response == null) {
            this.logger.error("sendSyncTransaction, query_response is nullptr");
            return (TransactionReceiptResponse)MessageFactory.getResponse(request, ErrorCode.SDK_INTERNAL_ERROR);
        }
        if (response.getErrorCode().isSuccess()) {
            this.logger.debug("sendSyncTransaction, send transaction done.");
        } else {
            this.logger.error("sendSyncTransaction, send transaction failed,return code.{},", (Object)response.getErrorCode().getErrorCode());
            receiptResponse.setErrorCode(response.getErrorCode());
        }
        QueryTransactionReceiptResponse queryReceiptResponse = (QueryTransactionReceiptResponse)response;
        receiptResponse.setTransactionReceipt(queryReceiptResponse.getTransactionReceipt());
        receiptResponse.setBlockNumber(queryReceiptResponse.getBlockNumber());
        receiptResponse.setTxIndex(queryReceiptResponse.getTxIndex());
        return receiptResponse;
    }

    protected TransactionReceiptResponse sendLocalTransaction(MessageType type, AbstractTransactionRequest request) {
        this.logger.debug("sendLocalTransaction, msgType:{}", (Object)request.getMessageType().name());
        if (!request.isValid()) {
            this.logger.error("sendLocalTransaction, request parameters is invalid");
            return (TransactionReceiptResponse)MessageFactory.getResponse(request, ErrorCode.SDK_INVALID_PARAMETER);
        }
        this.complete(request);
        if (request.getTransaction().getSignatureList().isEmpty()) {
            this.signRequest(request);
        } else {
            this.logger.debug("sendLocalTransaction, request signature is not empty");
        }
        this.logger.info("sendLocalTransaction, txHash:" + request.getTransaction().getHash());
        Response response = this.getNetwork().sendSyncRequest(request, new Hash(), this.env.getRequestOption().getSendRequestTimeoutMs());
        if (response == null) {
            this.logger.debug("sendLocalTransaction, response is null");
            return (TransactionReceiptResponse)MessageFactory.getResponse(request, ErrorCode.SDK_INTERNAL_ERROR);
        }
        TransactionReceiptResponse localResponse = (TransactionReceiptResponse)response;
        this.logger.debug("sendLocalTransaction response:{}", (Object)localResponse.toString());
        TransactionReceiptResponse txResponse = (TransactionReceiptResponse)MessageFactory.getResponse(type, request, ErrorCode.SUCCESS);
        if (txResponse == null) {
            this.logger.debug("sendLocalTransaction, receipt response is null");
            return (TransactionReceiptResponse)MessageFactory.getResponse(request, ErrorCode.SDK_INTERNAL_ERROR);
        }
        txResponse.setTransactionReceipt(localResponse.getTransactionReceipt());
        txResponse.setBlockNumber(localResponse.getBlockNumber());
        txResponse.setTxIndex(localResponse.getTxIndex());
        txResponse.setErrorCode(localResponse.getErrorCode());
        txResponse.setTxHash(localResponse.getTxHash());
        txResponse.setLocalTransaction();
        return txResponse;
    }

    protected int sendAsyncTransaction(final AbstractTransactionRequest request, final IAsyncCallback callback) {
        this.logger.debug("sendAsyncTransaction, msgType:{}", (Object)request.getMessageType().name());
        if (!request.isValid() || callback == null) {
            this.logger.error("sendAsyncTransaction, request parameters is invalid");
            return ErrorCode.SDK_INVALID_PARAMETER.getErrorCode();
        }
        this.complete(request);
        if (request.getTransaction().getSignatureList().isEmpty()) {
            this.signRequest(request);
        } else {
            this.logger.debug("sendAsyncTransaction, request signature is not empty");
        }
        this.logger.debug("sendAsyncTransaction :" + request.toString());
        int result = this.getNetwork().sendAsyncRequest(request, request.getTransaction().getHash(), new IAsyncCallback(){

            @Override
            public void onResponse(int errorCode, Response response) {
                if (errorCode != ErrorCode.SUCCESS.getErrorCode()) {
                    BaseService.this.logger.error("sendAsyncTransaction, AsyncCallback error code:{},response:{}", (Object)ErrorCode.valueOf(errorCode).getErrorCode(), (Object)response.toString());
                    callback.onResponse(errorCode, response);
                    return;
                }
                TransactionReceiptResponse transactionReceiptResponse = (TransactionReceiptResponse)response;
                if (transactionReceiptResponse.getErrorCode() != ErrorCode.SUCCESS) {
                    BaseService.this.logger.error("sendAsyncTransaction, AsyncCallback response error code:{},response:{}", (Object)ErrorCode.valueOf(errorCode).getErrorCode(), (Object)response.toString());
                    callback.onResponse(errorCode, response);
                    return;
                }
                int queryReceiptResult = BaseService.this.queryReceiptAsync(transactionReceiptResponse, callback, transactionReceiptResponse.getTxHash(), request.getGroupId(), System.currentTimeMillis() + (long)BaseService.this.env.getRequestOption().getQueryReceiptTimeoutMs().intValue());
                if (ErrorCode.SUCCESS.getErrorCode() != queryReceiptResult) {
                    BaseService.this.logger.error("sendAsyncTransaction, query receipt error code:{},response:{}", (Object)ErrorCode.valueOf(queryReceiptResult).getErrorCode(), (Object)response.toString());
                    transactionReceiptResponse.setErrorCode(ErrorCode.forNumber(queryReceiptResult));
                    callback.onResponse(queryReceiptResult, transactionReceiptResponse);
                }
            }
        }, this.env.getRequestOption().getSendRequestTimeoutMs());
        if (ErrorCode.SUCCESS.getErrorCode() != result) {
            ErrorCode errorCode = (ErrorCode)ErrorCode.valueOf(result);
            this.logger.error("sendAsyncTransaction, errorCode:{}", (Object)errorCode.name());
            return errorCode.getErrorCode();
        }
        return ErrorCode.SUCCESS.getErrorCode();
    }

    protected int sendAsyncLocalTransaction(final MessageType type, final AbstractTransactionRequest request, final IAsyncCallback callback) {
        this.logger.debug("sendAsyncLocalTransaction, msgType:{}", (Object)request.getMessageType().name());
        if (!request.isValid() || callback == null) {
            this.logger.error("sendAsyncLocalTransaction, request parameters is invalid");
            return ErrorCode.SDK_INVALID_PARAMETER.getErrorCode();
        }
        this.complete(request);
        if (request.getTransaction().getSignatureList().isEmpty()) {
            this.signRequest(request);
        } else {
            this.logger.debug("sendAsyncLocalTransaction, request signature is not empty");
        }
        this.logger.debug("sendAsyncLocalTransaction request:" + request.toString() + ",messageType :" + (Object)((Object)type));
        int result = this.getNetwork().sendAsyncRequest(request, new Hash(), new IAsyncCallback(){

            @Override
            public void onResponse(int errorCode, Response response) {
                TransactionReceiptResponse transactionReceiptResponse = (TransactionReceiptResponse)MessageFactory.getResponse(type, request, ErrorCode.valueOf(errorCode));
                if (transactionReceiptResponse == null) {
                    BaseService.this.logger.error("sendAsyncLocalTransaction, error code:{}", (Object)ErrorCode.valueOf(errorCode).getErrorCode());
                    callback.onResponse(errorCode, response);
                }
                if (errorCode != ErrorCode.SUCCESS.getErrorCode()) {
                    BaseService.this.logger.error("sendAsyncLocalTransaction, AsyncCallback error code:{},response:{}", (Object)ErrorCode.valueOf(errorCode).getErrorCode(), (Object)response.toString());
                    callback.onResponse(errorCode, response);
                    return;
                }
                TransactionReceiptResponse receiptResponse = (TransactionReceiptResponse)response;
                transactionReceiptResponse.setTransactionReceipt(receiptResponse.getTransactionReceipt());
                transactionReceiptResponse.setBlockNumber(receiptResponse.getBlockNumber());
                transactionReceiptResponse.setTxIndex(receiptResponse.getTxIndex());
                transactionReceiptResponse.setTxHash(receiptResponse.getTxHash());
                transactionReceiptResponse.setLocalTransaction();
                transactionReceiptResponse.setErrorCode(receiptResponse.getErrorCode());
                BaseService.this.logger.debug("sendAsyncLocalTransaction, AsyncCallback response error code:{},response:{}", (Object)ErrorCode.valueOf(errorCode).getErrorCode(), (Object)response.toString());
                callback.onResponse(ErrorCode.SUCCESS.getErrorCode(), transactionReceiptResponse);
            }
        }, this.env.getRequestOption().getSendRequestTimeoutMs());
        if (ErrorCode.SUCCESS.getErrorCode() != result) {
            ErrorCode errorCode = (ErrorCode)ErrorCode.valueOf(result);
            this.logger.error("sendAsyncLocalTransaction, errorCode:{}", (Object)errorCode.name());
            return errorCode.getErrorCode();
        }
        return ErrorCode.SUCCESS.getErrorCode();
    }

    protected Response queryReceiptSync(Hash txHash, BaseFixedSizeByteArray.Fixed20ByteArray groupId) {
        this.logger.debug("QueryTransactionReceiptResponse, txHash: " + txHash + ", groupId: " + ByteUtils.toHexString(groupId.getData()));
        QueryTransactionReceiptRequest queryTransactionReceiptRequest = new QueryTransactionReceiptRequest(txHash, groupId);
        long endTimestamp = System.currentTimeMillis() + (long)this.env.getRequestOption().getQueryReceiptTimeoutMs().intValue();
        QueryTransactionReceiptResponse receiptResponse = (QueryTransactionReceiptResponse)this.network.sendSyncRequest(queryTransactionReceiptRequest, new Hash(), this.env.getRequestOption().getSendRequestTimeoutMs());
        while (System.currentTimeMillis() < endTimestamp && receiptResponse != null) {
            if (ErrorCode.SUCCESS == receiptResponse.getErrorCode()) {
                return receiptResponse;
            }
            if (ErrorCode.SERVICE_QUERY_NO_RESULT == receiptResponse.getErrorCode() || ErrorCode.SERVICE_TX_WAITING_VERIFY == receiptResponse.getErrorCode() || ErrorCode.SERVICE_TX_WAITING_EXECUTE == receiptResponse.getErrorCode()) {
                try {
                    Thread.sleep(this.env.getRequestOption().getQueryReceiptIntervalMs().intValue());
                }
                catch (InterruptedException e) {
                    break;
                }
                receiptResponse = (QueryTransactionReceiptResponse)this.network.sendSyncRequest(queryTransactionReceiptRequest, new Hash(), this.env.getRequestOption().getSendRequestTimeoutMs());
                continue;
            }
            return receiptResponse;
        }
        return receiptResponse;
    }

    public int queryReceiptAsync(final TransactionReceiptResponse transactionReceiptResponse, final IAsyncCallback callback, final Hash txHash, final BaseFixedSizeByteArray.Fixed20ByteArray groupId, final long endTimestamp) {
        this.logger.debug("queryReceiptAsync, txHash: " + txHash + ", groupId: " + ByteUtils.toHexString(groupId.getData()));
        QueryTransactionReceiptRequest queryTransactionReceiptRequest = new QueryTransactionReceiptRequest(txHash, groupId);
        int result = this.network.sendAsyncRequest(queryTransactionReceiptRequest, new Hash(), new IAsyncCallback(){

            @Override
            public void onResponse(int errorCode, Response response) {
                if (errorCode != ErrorCode.SUCCESS.getErrorCode()) {
                    BaseService.this.logger.error("queryReceiptAsync, AsyncCallback error code:{}", (Object)ErrorCode.valueOf(errorCode).getErrorCode());
                    transactionReceiptResponse.setErrorCode(ErrorCode.valueOf(errorCode));
                    callback.onResponse(errorCode, transactionReceiptResponse);
                    return;
                }
                if (System.currentTimeMillis() < endTimestamp) {
                    if (response.getErrorCode().isSuccess()) {
                        BaseService.this.logger.debug("queryReceiptAsync, AsyncCallback response:{}", (Object)response.toString());
                        QueryTransactionReceiptResponse txResponse = (QueryTransactionReceiptResponse)response;
                        transactionReceiptResponse.setTransactionReceipt(txResponse.getTransactionReceipt());
                        transactionReceiptResponse.setTxIndex(txResponse.getTxIndex());
                        transactionReceiptResponse.setBlockNumber(txResponse.getBlockNumber());
                        transactionReceiptResponse.setTxHash(txHash);
                        callback.onResponse(errorCode, transactionReceiptResponse);
                        return;
                    }
                    if (ErrorCode.SERVICE_TX_WAITING_VERIFY == response.getErrorCode() || ErrorCode.SERVICE_TX_WAITING_EXECUTE == response.getErrorCode()) {
                        BaseService.this.logger.debug("queryReceiptAsync, query receipt by task errorCode:{}", (Object)response.getErrorCode());
                        BaseService.this.queryReceiptByTask(transactionReceiptResponse, callback, txHash, groupId, endTimestamp);
                        return;
                    }
                    BaseService.this.logger.debug("queryReceiptAsync, AsyncCallback: errorCode:{}, sequence:{}", (Object)errorCode, (Object)response.getSequenceId());
                    QueryTransactionReceiptResponse txResponse = (QueryTransactionReceiptResponse)response;
                    transactionReceiptResponse.setTransactionReceipt(txResponse.getTransactionReceipt());
                    transactionReceiptResponse.setErrorCode(txResponse.getErrorCode());
                    transactionReceiptResponse.setTxHash(txHash);
                    callback.onResponse(errorCode, transactionReceiptResponse);
                    return;
                }
            }
        }, this.env.getRequestOption().getSendRequestTimeoutMs());
        if (ErrorCode.SUCCESS.getErrorCode() != result) {
            ErrorCode errorCode = (ErrorCode)ErrorCode.valueOf(result);
            this.logger.error("queryReceiptAsync, errorCode:{}", (Object)errorCode.name());
            return errorCode.getErrorCode();
        }
        this.logger.debug("queryReceiptAsync, send message success.");
        return ErrorCode.SUCCESS.getErrorCode();
    }

    private void queryReceiptByTask(TransactionReceiptResponse transactionReceiptResponse, IAsyncCallback callback, Hash txHash, BaseFixedSizeByteArray.Fixed20ByteArray groupId, long endTimestamp) {
        QueryReceiptTask queryReceiptTask = new QueryReceiptTask(this, this.env.getRequestOption().getQueryReceiptIntervalMs(), this.getEnv().getLogger(), transactionReceiptResponse, callback, txHash, groupId, endTimestamp);
        this.timerTaskManager.registerTask(queryReceiptTask);
    }

    private void complete(AbstractTransactionRequest request) {
        long ts = this.getNetwork().getSystemTimestamp();
        request.setTxTimeNonce(ts, BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.valueOf(RandomUtil.randomize(ts + (long)request.hashCode() + System.nanoTime())), false);
        request.complete();
    }
}

