/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.envelope;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.AesGcmCipherV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.EccK1KDFV1;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.util.encoders.Hex;

public class EccK1EnvelopeSGX
implements EnvelopeBase {
    private List<PkeyCipherBase> pubkeyList;
    private PkeyCipherBase priKey;

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.ENVELOPE_ECCK1_LOCAL_SGX;
    }

    @Override
    public boolean isEncryptor() {
        return this.pubkeyList != null && this.pubkeyList.size() == 1;
    }

    @Override
    public boolean isDecryptor() {
        return this.priKey != null;
    }

    @Override
    public void setPkeyCipherList(List<PkeyCipherBase> pkeyCipherList) {
        if (pkeyCipherList == null || pkeyCipherList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (PkeyCipherBase pkeyCipher : pkeyCipherList) {
            if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_KDF_ECCK1_LOCAL_V1) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!pkeyCipher.isEncryptor()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPubkeyList(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pubkeyList.size() != 1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "more than one public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (Keypair keypair : pubkeyList) {
            if (keypair.getType() != KeyTypeEnum.KEY_ECCK1_PKCS8) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!keypair.isPubkey()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            EccK1KDFV1 pkeyCipher = new EccK1KDFV1(keypair);
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPrivkey(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair should not null");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_ECCK1_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!keypair.isPrivkey()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.priKey = new EccK1KDFV1(keypair);
    }

    @Override
    public void setPrivkey(PkeyCipherBase pkeyCipher) {
        if (pkeyCipher == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pkeyCipher should not null");
        }
        if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_KDF_ECCK1_LOCAL_V1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!pkeyCipher.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.priKey = pkeyCipher;
    }

    @Override
    public byte[] envelopeSeal(byte[] plaintext, byte[] secretKey) {
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public keys or public key more than one");
        }
        try {
            if (secretKey == null) {
                int secretKeyLength = 16;
                secretKey = new byte[secretKeyLength];
                for (int i = 0; i < secretKeyLength; ++i) {
                    secretKey[i] = (byte)new Random().nextInt(256);
                }
            }
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            byte[] gcmCipherTextOri = cipher.encrypt(plaintext);
            Keypair keypair = new Pkcs8KeyOperator().generate(KeyTypeEnum.KEY_ECCK1_PKCS8);
            PkeyCipherBase pkeyCipherBase = this.pubkeyList.get(0);
            byte[] kQRaw = pkeyCipherBase.encrypt(keypair.getPrivkeyId());
            byte[] z = new byte[36];
            System.arraycopy(kQRaw, 6, z, 0, 32);
            z[35] = 1;
            byte[] interKeyOri = HashFactory.getHash(HashTypeEnum.SHA256).hash(z);
            byte[] interKey = new byte[16];
            System.arraycopy(interKeyOri, 0, interKey, 0, 16);
            AesGcmCipherV1 userKeyCipher = new AesGcmCipherV1(interKey);
            byte[] sealedKey = userKeyCipher.encrypt(secretKey);
            byte[] output = new byte[111 + gcmCipherTextOri.length - 2];
            int index = 0;
            output[index++] = (byte)(this.pubkeyList.size() & 3);
            output[index++] = 64;
            output[index++] = 4;
            System.arraycopy(keypair.getPubkeyId(), 0, output, 3, 64);
            System.arraycopy(sealedKey, 2, output, 67, 44);
            System.arraycopy(gcmCipherTextOri, 2, output, 111, gcmCipherTextOri.length - 2);
            return output;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] envelopeOpen(byte[] ciphertext, byte[] secretKey) {
        if (!this.isDecryptor() && secretKey == null) {
            throw new MychainSdkException(ErrorCode.TEE_CODE_DECRYPTION_FAILURE, "no privatekey and no secret key");
        }
        if (secretKey != null && secretKey.length != 16) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid secret_key,secret key is not 16 bytes");
        }
        byte[] encryptedText = new byte[2 + ciphertext.length - 111];
        System.arraycopy(AlgoIdEnum.CIPHER_AES_GCM_LOCAL_V1.toBytes(), 0, encryptedText, 0, 2);
        System.arraycopy(ciphertext, 111, encryptedText, 2, encryptedText.length - 2);
        if (secretKey != null) {
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            return cipher.decrypt(encryptedText);
        }
        byte[] R = new byte[64];
        System.arraycopy(ciphertext, 3, R, 0, 64);
        System.out.println(Hex.toHexString((byte[])R));
        byte[] newPrivateKey = new EccK1KDFV1(new Keypair(R)).encrypt(((EccK1KDFV1)this.priKey).getPrivateKey());
        System.out.println(Hex.toHexString((byte[])newPrivateKey));
        byte[] z = new byte[36];
        System.arraycopy(newPrivateKey, 6, z, 0, 32);
        z[35] = 1;
        byte[] interKeyOri = HashFactory.getHash(HashTypeEnum.SHA256).hash(z);
        byte[] interKey = new byte[16];
        System.arraycopy(interKeyOri, 0, interKey, 0, 16);
        byte[] encryptedKey = new byte[46];
        System.arraycopy(AlgoIdEnum.CIPHER_AES_GCM_LOCAL_V1.toBytes(), 0, encryptedKey, 0, 2);
        System.arraycopy(ciphertext, 67, encryptedKey, 2, 44);
        AesGcmCipherV1 userKeyCipher = new AesGcmCipherV1(interKey);
        System.out.println(Hex.toHexString((byte[])interKey));
        secretKey = userKeyCipher.decrypt(encryptedKey);
        AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
        return cipher.decrypt(encryptedText);
    }

    public static void main(String[] args) {
        ArrayList<Keypair> keypairs = new ArrayList<Keypair>();
        Keypair keypair = new Keypair(Hex.decode((String)"5955e9deff91af6c4801fedfd5638de482f8bc5f09f18839cf92f380aeae4284be210b9668777ae7f09fc8a2e1ee03f06f512ba0b8771288efad0d0d96047a41"), Hex.decode((String)"307447966efeb7d1e003285c7f8d74a158c72d0face4c4800d867f8e9af7630f"));
        keypairs.add(keypair);
        EccK1EnvelopeSGX eccK1EnvelopeSGX = new EccK1EnvelopeSGX();
        eccK1EnvelopeSGX.setPubkeyList(keypairs);
        eccK1EnvelopeSGX.setPrivkey(keypair);
        byte[] sealed = eccK1EnvelopeSGX.envelopeSeal("hello world".getBytes(), null);
        System.out.println(Hex.toHexString((byte[])sealed));
        sealed = Hex.decode((String)"014004865d384a32ad539fec69b8a2892a9601302f0b733f1e1cc6b86249d700bfa977d8da28275176b8acfdfb9f84219e1a12b4e15172ab6551caaee72f3d1f0e58d772547cb97c478598fc361594bf0aeaf88652ad4b3619cac92b173a2b340e69daef677b73f1d4f74804c358d946bfe50f8bc904cec26770aba02d224fb432309c97aa52d5b8805d7c62170f293d282904e6076a");
        byte[] plaintext = eccK1EnvelopeSGX.envelopeOpen(sealed, null);
        System.out.println(new String(plaintext));
    }
}

