/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.crypto.envelope;

import com.alipay.mychain.sdk.crypto.AlgoIdEnum;
import com.alipay.mychain.sdk.crypto.cipher.AesGcmCipherV1;
import com.alipay.mychain.sdk.crypto.envelope.EnvelopeBase;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.keyoperator.Pkcs8KeyOperator;
import com.alipay.mychain.sdk.crypto.keypair.KeyTypeEnum;
import com.alipay.mychain.sdk.crypto.keypair.Keypair;
import com.alipay.mychain.sdk.crypto.pkeycipher.EccK1KDFV1;
import com.alipay.mychain.sdk.crypto.pkeycipher.PkeyCipherBase;
import com.alipay.mychain.sdk.errorcode.ErrorCode;
import com.alipay.mychain.sdk.exception.MychainSdkException;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class EccK1EnvelopeV1
implements EnvelopeBase {
    private static final int IV_LEN = 12;
    private static final int AUTHTAG_LEN = 16;
    private List<PkeyCipherBase> pubkeyList;
    private PkeyCipherBase privkey;

    @Override
    public AlgoIdEnum getAlgo() {
        return AlgoIdEnum.ENVELOPE_ECCK1_LOCAL_V1;
    }

    @Override
    public boolean isEncryptor() {
        return this.pubkeyList != null && this.pubkeyList.size() > 0;
    }

    @Override
    public boolean isDecryptor() {
        return this.privkey != null;
    }

    @Override
    public void setPkeyCipherList(List<PkeyCipherBase> pkeyCipherList) {
        if (pkeyCipherList == null || pkeyCipherList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pkeyCipherList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (PkeyCipherBase pkeyCipher : pkeyCipherList) {
            if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_KDF_ECCK1_LOCAL_V1) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!pkeyCipher.isEncryptor()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPubkeyList(List<Keypair> pubkeyList) {
        if (pubkeyList == null || pubkeyList.size() == 0) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "public keys should not empty");
        }
        if (pubkeyList.size() > 65535) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "too many public keys");
        }
        this.pubkeyList = new ArrayList<PkeyCipherBase>();
        for (Keypair keypair : pubkeyList) {
            if (keypair.getType() != KeyTypeEnum.KEY_ECCK1_PKCS8) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
            }
            if (!keypair.isPubkey()) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public key");
            }
            EccK1KDFV1 pkeyCipher = new EccK1KDFV1(keypair);
            this.pubkeyList.add(pkeyCipher);
        }
    }

    @Override
    public void setPrivkey(Keypair keypair) {
        if (keypair == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "keypair should not null");
        }
        if (keypair.getType() != KeyTypeEnum.KEY_ECCK1_PKCS8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!keypair.isPrivkey()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = new EccK1KDFV1(keypair);
    }

    @Override
    public void setPrivkey(PkeyCipherBase pkeyCipher) {
        if (pkeyCipher == null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "pkeyCipher should not null");
        }
        if (pkeyCipher.getAlgo() != AlgoIdEnum.PKEY_KDF_ECCK1_LOCAL_V1) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid keypair type!");
        }
        if (!pkeyCipher.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        this.privkey = pkeyCipher;
    }

    @Override
    public byte[] envelopeSeal(byte[] plaintext, byte[] secretKey) {
        if (!this.isEncryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PUBLIC_KEY, "no public keys");
        }
        if (secretKey != null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "secretKey must null!");
        }
        try {
            int pubkeyNr = this.pubkeyList.size();
            int totalSize = 2 + 72 * pubkeyNr + 2 + 2 + 12 + 16 + plaintext.length;
            byte[] output = new byte[6 + totalSize];
            Keypair keypair = new Pkcs8KeyOperator().generate(KeyTypeEnum.KEY_ECCK1_PKCS8);
            secretKey = this.kdf(keypair.getPubkeyEncoded());
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            byte[] gcmCipherText = cipher.encrypt(plaintext);
            int index = 0;
            byte[] envelopeAlgoId = this.getAlgo().toBytes();
            System.arraycopy(envelopeAlgoId, 0, output, index, 2);
            byte[] totalSizeBytes = ByteUtils.intToBytes(totalSize);
            System.arraycopy(totalSizeBytes, 0, output, index += 2, 4);
            index += 4;
            output[index++] = (byte)(pubkeyNr >> 8 & 0xFF);
            output[index++] = (byte)(pubkeyNr & 0xFF);
            for (PkeyCipherBase publicKey : this.pubkeyList) {
                byte[] secretKeyEncrypted = publicKey.encrypt(keypair.getPrivkeyId());
                output[index++] = (byte)(secretKeyEncrypted.length >> 8 & 0xFF);
                output[index++] = (byte)(secretKeyEncrypted.length & 0xFF);
                System.arraycopy(secretKeyEncrypted, 0, output, index, secretKeyEncrypted.length);
                index += secretKeyEncrypted.length;
            }
            output[index++] = (byte)(gcmCipherText.length >> 8 & 0xFF);
            output[index++] = (byte)(gcmCipherText.length & 0xFF);
            System.arraycopy(gcmCipherText, 0, output, index, gcmCipherText.length);
            return output;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    @Override
    public byte[] envelopeOpen(byte[] ciphertext, byte[] secretKey) {
        if (!this.isDecryptor()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PRIVATE_KEY, "no private key");
        }
        if (ciphertext == null || ciphertext.length < 8) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid cipher text!");
        }
        if (secretKey != null) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "secretKey must null!");
        }
        if (AlgoIdEnum.valueOf(ciphertext) != this.getAlgo()) {
            throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid algoid!");
        }
        try {
            int gmcCipherSize;
            int i;
            int pubkeyNr;
            int index = 2;
            byte[] totalSizeBytes = Arrays.copyOfRange(ciphertext, index, index + 4);
            int totalSize = ByteUtils.byteArrayToInt(totalSizeBytes);
            if (totalSize != ciphertext.length - (index += 4)) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid totalSize!");
            }
            if ((pubkeyNr = ((ciphertext[index++] & 0xFF) << 8) + (ciphertext[index++] & 0xFF)) == 0) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid public key number!");
            }
            if (ciphertext.length <= index + pubkeyNr * 72) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid length of ciphertext.");
            }
            for (i = 0; i < pubkeyNr; ++i) {
                int size;
                if ((size = ((ciphertext[index++] & 0xFF) << 8) + (ciphertext[index++] & 0xFF)) != 70) {
                    throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid size of encrypted public key.");
                }
                byte[] secretKeyEncrypted = Arrays.copyOfRange(ciphertext, index, index + 70);
                index += 70;
                try {
                    byte[] tempPubkey = this.privkey.decrypt(secretKeyEncrypted);
                    secretKey = this.kdf(tempPubkey);
                    ++i;
                    break;
                }
                catch (Exception e) {
                    if (i != pubkeyNr - 1) continue;
                    throw e;
                }
            }
            while (i < pubkeyNr) {
                index += 72;
                ++i;
            }
            AesGcmCipherV1 cipher = new AesGcmCipherV1(secretKey);
            if ((gmcCipherSize = ((ciphertext[index++] & 0xFF) << 8) + (ciphertext[index++] & 0xFF)) != ciphertext.length - index) {
                throw new MychainSdkException(ErrorCode.SDK_INVALID_PARAMETER, "invalid length of gmcCipherSize.");
            }
            byte[] gcmCipher = Arrays.copyOfRange(ciphertext, index, ciphertext.length);
            byte[] plainText = cipher.decrypt(gcmCipher);
            return plainText;
        }
        catch (Exception e) {
            throw new MychainSdkException(ErrorCode.OTHERS, ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    private byte[] kdf(byte[] input) {
        byte[] hash = HashFactory.getHash().hash(input);
        byte[] hash2 = Arrays.copyOfRange(hash, 16, 32);
        byte[] secretKey = new byte[16];
        for (int i = 0; i < 16; ++i) {
            secretKey[i] = (byte)(hash[i] ^ hash2[i]);
        }
        return secretKey;
    }
}

