/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.metrics;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.domain.metrics.MetricsAccCounterInfo;
import com.alipay.mychain.sdk.domain.metrics.MetricsAccountType;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MetricsAccInfoDetail
extends MychainObject {
    MetricsAccountType accountsType = MetricsAccountType.ORDINARY_ACCOUNT;
    Identity account = new Identity();
    private List<MetricsAccCounterInfo> accountCounterList;

    public MetricsAccInfoDetail(MetricsAccountType accountsType, Identity account, List<MetricsAccCounterInfo> accountCounterList) {
        this.accountsType = accountsType;
        this.account = account;
        this.accountCounterList = accountCounterList;
    }

    public MetricsAccInfoDetail() {
    }

    public MetricsAccountType getAccountsType() {
        return this.accountsType;
    }

    public void setAccountsType(MetricsAccountType accountsType) {
        this.accountsType = accountsType;
    }

    public Identity getAccount() {
        return this.account;
    }

    public void setAccount(Identity account) {
        this.account = account;
    }

    public List<MetricsAccCounterInfo> getAccountCounterList() {
        return this.accountCounterList;
    }

    public void setAccountCounterList(List<MetricsAccCounterInfo> accountCounterList) {
        this.accountCounterList = accountCounterList;
    }

    @Override
    public byte[] toRlp() {
        byte[] typeBytes = Rlp.encodeInt(this.accountsType.getCode());
        byte[] accountBytes = Rlp.encodeElement(this.account.getValue());
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (MetricsAccCounterInfo item : this.accountCounterList) {
            data.add(item.toRlp());
        }
        return Rlp.encodeList(typeBytes, accountBytes, Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        this.accountsType = MetricsAccountType.getType(ByteUtils.byteArrayToInt(((RlpElement)list.get(0)).getRlpData()));
        this.account = new Identity(((RlpElement)list.get(1)).getRlpData());
        this.accountCounterList = new ArrayList<MetricsAccCounterInfo>();
        RlpList data = (RlpList)list.get(2);
        for (RlpElement element : data) {
            MetricsAccCounterInfo item = new MetricsAccCounterInfo();
            item.fromRlp((RlpList)element);
            this.accountCounterList.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("account_type", (Object)this.accountsType.getCode());
        jsonObject.put("account_identity", (Object)ByteUtils.toHexString(this.account.getValue()));
        JSONArray jsonArray = new JSONArray();
        if (this.accountCounterList != null) {
            for (MetricsAccCounterInfo item : this.accountCounterList) {
                JSONObject object = new JSONObject();
                item.toJson(object);
                jsonArray.add((Object)object);
            }
        }
        jsonObject.put("account_counter_info", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.accountsType = MetricsAccountType.getType(jsonObject.getIntValue("account_type"));
        this.account = new Identity(jsonObject.getString("account_identity"));
        this.accountCounterList = new ArrayList<MetricsAccCounterInfo>();
        JSONArray jsonArray = jsonObject.getJSONArray("account_counter_info");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                MetricsAccCounterInfo object = new MetricsAccCounterInfo();
                object.fromJson((JSONObject)iterator.next());
                this.accountCounterList.add(object);
            }
        }
    }
}

