/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.transaction;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class Extension
extends MychainObject {
    private int key;
    private byte[] value;

    public Extension(int key, byte[] value) {
        this.key = key;
        this.value = value;
    }

    public Extension() {
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public byte[] toRlp() {
        byte[] keyBytes = Rlp.encodeInt(this.key);
        byte[] valueBytes = Rlp.encodeElement(this.value);
        return Rlp.encodeList(keyBytes, valueBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.key = ByteUtils.byteArrayToInt(((RlpElement)list.get(0)).getRlpData());
        this.value = ((RlpElement)list.get(1)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("key", (Object)this.key);
        jsonObject.put("value", (Object)ByteUtils.toHexString(this.value));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.key = jsonObject.getIntValue("key");
        this.value = ByteUtils.hexStringToBytes(jsonObject.getString("value"));
    }
}

