/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryRelatedTransactionListResponse
extends Response {
    private List<Hash> txHashes;

    public QueryRelatedTransactionListResponse(List<Hash> txHashes) {
        super(MessageType.MSG_TYPE_QUERY_RESP_RELATED_TX_LIST);
        this.txHashes = txHashes;
    }

    public QueryRelatedTransactionListResponse() {
        super(MessageType.MSG_TYPE_QUERY_RESP_RELATED_TX_LIST);
    }

    public List<Hash> getTxHashes() {
        return this.txHashes;
    }

    @Override
    public byte[] toRlp() {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        for (Hash item : this.txHashes) {
            data.add(Rlp.encodeElement(item.getValue()));
        }
        return Rlp.encodeList(super.toRlp(), Rlp.encodeList(data));
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.txHashes = new ArrayList<Hash>();
        RlpList data = (RlpList)list.get(1);
        for (RlpElement element : data) {
            Hash item = new Hash(element.getRlpData());
            this.txHashes.add(item);
        }
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONArray jsonArray = new JSONArray();
        if (this.txHashes != null) {
            for (Hash item : this.txHashes) {
                jsonArray.add((Object)ByteUtils.toHexString(item.getValue()));
            }
        }
        jsonObject.put("hash_list", (Object)jsonArray);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.txHashes = new ArrayList<Hash>();
        JSONArray jsonArray = jsonObject.getJSONArray("hash_list");
        if (jsonArray != null) {
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                Hash object = new Hash((String)iterator.next());
                this.txHashes.add(object);
            }
        }
    }
}

