/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto;

import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.crypto.rangeproof.NativeRangeProof;
import java.util.ArrayList;

public class BulletProof {
    public static final int BLIND_SIZE = 32;
    public static final int COMMIT_SIZE = 32;
    public static final int MAX_PROOF_COMMITS = 16;

    private static void checkValue(long value) throws CryptoException {
        if (0L > value) {
            throw new CryptoException("value parameter should not be less than 0.");
        }
    }

    private static void checkValue(long[] values) throws CryptoException {
        if (null == values) {
            throw new CryptoException("values parameter should not be null.");
        }
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            if (0L <= value) continue;
            throw new CryptoException("value parameter should not be less than 0.");
        }
    }

    private static void checkBlindFactor(byte[] blind) throws CryptoException {
        if (null == blind) {
            throw new CryptoException("blind parameter should not be null.");
        }
        if (32 != blind.length) {
            throw new CryptoException("The length of blind factor must be 32 in bytes.");
        }
    }

    private static void checkCommit(byte[] commit) throws CryptoException {
        if (null == commit) {
            throw new CryptoException("commit parameter should not be null.");
        }
        if (32 != commit.length) {
            throw new CryptoException("The length of commit must be 32 in bytes.");
        }
    }

    private static void checkProof(byte[] proof, int nCommits) throws CryptoException {
        int proofLen = NativeRangeProof.nativeGetProofLength(nCommits);
        if (null == proof) {
            throw new CryptoException("proof parameter should not be null.");
        }
        if (proofLen != proof.length) {
            throw new CryptoException("The length of proof should be " + proofLen + " in bytes.");
        }
    }

    public static byte[] generateBlindFactor() throws CryptoException {
        byte[] blind = new byte[32];
        int rtc = NativeRangeProof.nativeBlindFactorGenerate(blind);
        if (0 != rtc) {
            throw new CryptoException("generateBlindFactor fail.");
        }
        return blind;
    }

    public static byte[] addBlindFactors(ArrayList<byte[]> posBlindList, ArrayList<byte[]> negBlindList) throws CryptoException {
        byte[] blind;
        int rtc;
        byte[] bf;
        int i;
        int szPos = 0;
        int szNeg = 0;
        Object posBlinds = null;
        Object negBlinds = null;
        if (null == posBlindList && null == negBlindList) {
            throw new CryptoException("addBlindFactors input parameter should not be null.");
        }
        if (null != posBlindList) {
            szPos = posBlindList.size();
            posBlinds = new byte[szPos][];
            for (i = 0; i < szPos; ++i) {
                bf = posBlindList.get(i);
                BulletProof.checkBlindFactor(bf);
                posBlinds[i] = bf;
            }
        }
        if (null != negBlindList) {
            szNeg = negBlindList.size();
            negBlinds = new byte[szNeg][];
            for (i = 0; i < szNeg; ++i) {
                bf = negBlindList.get(i);
                BulletProof.checkBlindFactor(bf);
                negBlinds[i] = bf;
            }
        }
        if (0 != (rtc = NativeRangeProof.nativeBlindFactorsSum(blind = new byte[32], posBlinds, szPos, negBlinds, szNeg))) {
            throw new CryptoException("generateCommit fail.");
        }
        return blind;
    }

    public static byte[] generateCommit(byte[] blind, long value) throws CryptoException {
        BulletProof.checkValue(value);
        BulletProof.checkBlindFactor(blind);
        byte[] commit = new byte[32];
        int rtc = NativeRangeProof.nativePedersenCommitGenerate(commit, blind, value);
        if (0 != rtc) {
            throw new CryptoException("generateCommit fail.");
        }
        return commit;
    }

    public static boolean verifyCommit(byte[] commit, byte[] blind, long value) throws CryptoException {
        BulletProof.checkValue(value);
        BulletProof.checkBlindFactor(blind);
        BulletProof.checkCommit(commit);
        int rtc = NativeRangeProof.nativePedersenCommitVerify(commit, blind, value);
        if (256 != rtc && 257 != rtc) {
            throw new CryptoException("verifyProof fail.");
        }
        return 256 == rtc;
    }

    public static boolean isCommitsSumZero(ArrayList<byte[]> posCommits, ArrayList<byte[]> negCommits) throws CryptoException {
        byte[] pc;
        int i;
        if (null == posCommits || null == negCommits) {
            throw new CryptoException("isCommitsSumZero input parameter should not be null.");
        }
        int szPos = posCommits.size();
        int szNeg = negCommits.size();
        if (0 == szPos || 0 == szNeg) {
            throw new CryptoException("isCommitsSumZero input parameter should not be empty.");
        }
        byte[][] posPC = new byte[szPos][];
        byte[][] negPC = new byte[szNeg][];
        for (i = 0; i < szPos; ++i) {
            pc = posCommits.get(i);
            BulletProof.checkCommit(pc);
            posPC[i] = pc;
        }
        for (i = 0; i < szNeg; ++i) {
            pc = negCommits.get(i);
            BulletProof.checkCommit(pc);
            negPC[i] = pc;
        }
        int rtc = NativeRangeProof.nativePedersenCommitsSumIsZero(posPC, szPos, negPC, szNeg);
        if (512 != rtc && 513 != rtc) {
            throw new CryptoException("isCommitsSumZero fail.");
        }
        return 512 == rtc;
    }

    public static byte[] addCommits(ArrayList<byte[]> posCommits, ArrayList<byte[]> negCommits) throws CryptoException {
        int rtc;
        byte[] pc;
        int i;
        int szPos = 0;
        int szNeg = 0;
        Object posPC = null;
        Object negPC = null;
        byte[] commit = new byte[32];
        if (null == posCommits && null == negCommits) {
            throw new CryptoException("addBlindFactors input parameter should not be null.");
        }
        if (null != posCommits) {
            szPos = posCommits.size();
            posPC = new byte[szPos][];
            for (i = 0; i < szPos; ++i) {
                pc = posCommits.get(i);
                BulletProof.checkCommit(pc);
                posPC[i] = pc;
            }
        }
        if (null != negCommits) {
            szNeg = negCommits.size();
            negPC = new byte[szNeg][];
            for (i = 0; i < szNeg; ++i) {
                pc = negCommits.get(i);
                BulletProof.checkCommit(pc);
                negPC[i] = pc;
            }
        }
        if (0 != (rtc = NativeRangeProof.nativePedersenCommitsSum(commit, posPC, szPos, negPC, szNeg))) {
            throw new CryptoException("addCommits fail.");
        }
        return commit;
    }

    public static byte[] generateProof(ArrayList<byte[]> blindlist, long[] values) throws CryptoException {
        if (null == blindlist) {
            throw new CryptoException("generateProof input parameter blind invalid.");
        }
        int nCommits = values.length;
        if (0 >= nCommits || 16 < nCommits) {
            throw new CryptoException("generateProof input parameter invalid.");
        }
        if (blindlist.size() != nCommits) {
            throw new CryptoException("generateProof input parameter invalid");
        }
        int proofLen = NativeRangeProof.nativeGetProofLength(nCommits);
        byte[][] blinds = new byte[nCommits][];
        byte[] proof = new byte[proofLen];
        for (int i = 0; i < nCommits; ++i) {
            byte[] bf = blindlist.get(i);
            BulletProof.checkBlindFactor(bf);
            blinds[i] = bf;
        }
        BulletProof.checkValue(values);
        int rtc = NativeRangeProof.nativeBulletProofBatchGenerate(proof, blinds, values, nCommits);
        if (0 != rtc) {
            throw new CryptoException("generateProof Batch fail.");
        }
        return proof;
    }

    public static boolean verifyProof(byte[] proof, ArrayList<byte[]> commitlist) throws CryptoException {
        if (null == commitlist || null == proof) {
            throw new CryptoException("verifyProof input parameter should not be null.");
        }
        if (0 == commitlist.size()) {
            throw new CryptoException("verifyProof input parameter size should be empty.");
        }
        int nCommits = commitlist.size();
        byte[][] commits = new byte[nCommits][];
        for (int i = 0; i < nCommits; ++i) {
            byte[] pc = commitlist.get(i);
            BulletProof.checkCommit(pc);
            commits[i] = pc;
        }
        int rtc = NativeRangeProof.nativeBulletProofBatchVerify(proof, commits, nCommits);
        if (256 != rtc && 257 != rtc) {
            throw new CryptoException("verifyProof batch fail.");
        }
        return 256 == rtc;
    }

    public static byte[] generateProof(byte[] blind, long value) throws CryptoException {
        int nCommits = 1;
        BulletProof.checkValue(value);
        BulletProof.checkBlindFactor(blind);
        int proofLen = NativeRangeProof.nativeGetProofLength(nCommits);
        byte[] proof = new byte[proofLen];
        int rtc = NativeRangeProof.nativeBulletProofGenerate(proof, blind, value);
        if (0 != rtc) {
            throw new CryptoException("generateProof fail.");
        }
        return proof;
    }

    public static boolean verifyProof(byte[] proof, byte[] commit) throws CryptoException {
        int nCommits = 1;
        BulletProof.checkCommit(commit);
        BulletProof.checkProof(proof, nCommits);
        int rtc = NativeRangeProof.nativeBulletProofVerify(proof, commit);
        if (256 != rtc && 257 != rtc) {
            throw new CryptoException("verifyProof error.");
        }
        return 256 == rtc;
    }
}

