/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson15.serializer;

import com.alibaba.fastjson15.JSONArray;
import com.alibaba.fastjson15.parser.DefaultJSONParser;
import com.alibaba.fastjson15.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson15.serializer.JSONSerializer;
import com.alibaba.fastjson15.serializer.ObjectSerializer;
import com.alibaba.fastjson15.serializer.SerializeWriter;
import com.alibaba.fastjson15.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicIntegerArrayCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final AtomicIntegerArrayCodec instance = new AtomicIntegerArrayCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        AtomicIntegerArray array = (AtomicIntegerArray)object;
        int len = array.length();
        out.append('[');
        for (int i = 0; i < len; ++i) {
            int val = array.get(i);
            if (i != 0) {
                out.write(',');
            }
            out.writeInt(val);
        }
        out.append(']');
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        if (parser.getLexer().token() == 8) {
            parser.getLexer().nextToken(16);
            return null;
        }
        JSONArray array = new JSONArray();
        parser.parseArray(array);
        AtomicIntegerArray atomicArray = new AtomicIntegerArray(array.size());
        for (int i = 0; i < array.size(); ++i) {
            atomicArray.set(i, array.getInteger(i));
        }
        return (T)atomicArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

