/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk;

import com.upay.sdk.Base64;
import com.upay.sdk.HexUtils;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AESUtils {
    public static final int KEY_SIZE_BIT_128 = 128;
    public static final int KEY_SIZE_BIT_256 = 256;
    public static final String CHARSTER_ENCODING = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(AESUtils.class);

    public static String encrypt(String content, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES");
            byte[] byteContent = content.getBytes(CHARSTER_ENCODING);
            cipher.init(1, AESUtils.genKey(key));
            byte[] result = cipher.doFinal(byteContent);
            return HexUtils.toHexStr(result);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String decrypt(String content, String key) {
        try {
            byte[] decryptFrom = HexUtils.toByte(content);
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, AESUtils.genKey(key));
            byte[] result = cipher.doFinal(decryptFrom);
            return new String(result);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static SecretKeySpec genKey(String sourceKey) {
        byte[] enCodeFormat = new byte[]{0};
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(sourceKey.getBytes(CHARSTER_ENCODING));
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            enCodeFormat = secretKey.getEncoded();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return new SecretKeySpec(enCodeFormat, "AES");
    }

    public static byte[] encrypt(byte[] data, byte[] key) {
        if (key.length != 16) {
            throw new RuntimeException("Invalid AES key length (must be 16 bytes)");
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec seckey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(1, seckey);
            byte[] result = cipher.doFinal(data);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    public static byte[] decrypt(byte[] data, byte[] key) {
        if (key.length != 16) {
            throw new RuntimeException("Invalid AES key length (must be 16 bytes)");
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec seckey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, seckey);
            byte[] result = cipher.doFinal(data);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("decrypt fail!", e);
        }
    }

    public static String encryptToBase64(String data, String key) {
        try {
            byte[] valueByte = AESUtils.encrypt(data.getBytes(CHARSTER_ENCODING), key.getBytes(CHARSTER_ENCODING));
            return new String(Base64.encode(valueByte));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    public static String decryptFromBase64(String data, String key) {
        try {
            byte[] originalData = Base64.decode(data.getBytes(CHARSTER_ENCODING));
            byte[] valueByte = AESUtils.decrypt(originalData, key.getBytes(CHARSTER_ENCODING));
            return new String(valueByte, CHARSTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("decrypt fail!", e);
        }
    }

    public static String encryptWithKeyBase64(String data, String key) {
        try {
            byte[] valueByte = AESUtils.encrypt(data.getBytes(CHARSTER_ENCODING), Base64.decode(key.getBytes()));
            return new String(Base64.encode(valueByte));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("encrypt fail!", e);
        }
    }

    public static String decryptWithKeyBase64(String data, String key) {
        try {
            byte[] originalData = Base64.decode(data.getBytes(CHARSTER_ENCODING));
            byte[] valueByte = AESUtils.decrypt(originalData, Base64.decode(key.getBytes(CHARSTER_ENCODING)));
            return new String(valueByte, CHARSTER_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("decrypt fail!", e);
        }
    }

    public static byte[] genarateRandomKey() {
        KeyGenerator keygen = null;
        try {
            keygen = KeyGenerator.getInstance("AES/ECB/PKCS5Padding");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(" genarateRandomKey fail!", e);
        }
        SecureRandom random = new SecureRandom();
        keygen.init(random);
        SecretKey key = keygen.generateKey();
        return key.getEncoded();
    }

    public static String genarateRandomKeyWithBase64() {
        return new String(Base64.encode(AESUtils.genarateRandomKey()));
    }
}

