/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.cashier.bindcard.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public class UnBindCardBuilder
extends BuilderSupport {
    private String merchantId;
    private String bindCardId;
    private String merchantUserId;

    public UnBindCardBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public UnBindCardBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public UnBindCardBuilder setBindCardId(String bindCardId) {
        this.bindCardId = bindCardId;
        return this;
    }

    public UnBindCardBuilder setMerchantUserId(String merchantUserId) {
        this.merchantUserId = merchantUserId;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.bindCardId)) {
            json.put("bindCardId", (Object)this.bindCardId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.merchantUserId)) {
            json.put("merchantUserId", (Object)this.merchantUserId);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.bindCardId)).append(StringUtils.defaultString((String)this.merchantUserId));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

