/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.cp.executer;

import com.alibaba.fastjson15.JSON;
import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.cp.builder.OrderBuilder;
import com.upay.sdk.cp.builder.QueryBuilder;
import com.upay.sdk.cp.builder.RefundBuilder;
import com.upay.sdk.cp.builder.RefundQueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpPayOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(CpPayOrderExecuter.class);

    public void orderV_3(OrderBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                LOGGER.info("CpPayOrderExecuter orderV_3 builder: {}", (Object)JSON.toJSONString(builder));
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("CpPayOrderExecuter orderV_3 requestData: {}", (Object)requestData.toJSONString());
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCpOnlinePayOrderUrl(), requestData);
                LOGGER.info("CpPayOrderExecuter orderV_3 responseStr: {}", (Object)responseStr);
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("CpPayOrderExecuter orderV_3 responseStr111: {}", (Object)responseData);
                this.bothVerifyHmacOrder(responseData);
                LOGGER.info("CpPayOrderExecuter orderV_3 responseStr: {}", (Object)responseData);
                if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS)) && StringUtils.isEmpty((CharSequence)responseData.getString(Constants.JSSTRING))) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block6;
                }
                if (Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (StringUtils.isNotEmpty((CharSequence)responseData.getString(Constants.JSSTRING))) {
                    resultListener.success(responseData);
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("request order exception", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void callbackV_3(JSONObject responseData, ResultListener paymentListener) {
        LOGGER.info("CpPayOrderExecuter callbackV_3 responseData: {}", (Object)responseData);
        if (paymentListener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CpPayOrderExecuter callbackV_3 data: {}", (Object)data);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (!Constants.SUCCESS.equals(status)) {
            if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                paymentListener.failure(data);
                return;
            }
            if (Constants.INIT.equals(status)) {
                paymentListener.pending(data);
                return;
            }
            throw new ResponseException(data);
        }
        paymentListener.success(data);
    }

    public void refundV_3(RefundBuilder builder, ResultListener listener) {
        block6: {
            if (listener == null) {
                throw new NullPointerException();
            }
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("CpPayOrderExecuter refundV_3 requestData: {}", (Object)requestData);
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCpOnlinePayRefundUrl(), requestData);
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                LOGGER.info("CpPayOrderExecuter refundV_3 responseData: {}", (Object)responseData);
                JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
                this.bothVerifyHmacOrder(data);
                String status = data.getString(Constants.STATUS);
                if (Constants.SUCCESS.equals(status)) {
                    listener.success(data);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    listener.failure(data);
                    break block6;
                }
                if (Constants.INIT.equals(status)) {
                    listener.pending(data);
                    break block6;
                }
                throw new ResponseException(data);
            }
            catch (Exception e) {
                LOGGER.error("CpPayOrderExecuter refundV_3 exception : ", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void queryV_3(QueryBuilder builder, ResultListener paymentListener) {
        if (paymentListener == null) {
            throw new NullPointerException();
        }
        try {
            JSONObject requestData = builder.bothEncryptBuild();
            LOGGER.debug("CpPayOrderExecuter queryV_3 requestData: {}", (Object)requestData);
            String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCpOnlinePayQueryUrl(), requestData);
            JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
            LOGGER.debug("CpPayOrderExecuter queryV_3 responseStr: {}", (Object)responseStr);
            this.callbackV_3(responseData, paymentListener);
        }
        catch (Exception e) {
            LOGGER.error("CpPayOrderExecuter queryv_3 exception : ", (Throwable)e);
            throw new UnknownException(e);
        }
    }

    public void refundCallbackV_3(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        LOGGER.info("CpPayOrderExecuter refundCallbackV_3 data: {}", (Object)data);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (Constants.SUCCESS.equals(status)) {
            listener.success(data);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(data);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(data);
        } else {
            throw new ResponseException(data);
        }
    }

    public void refundQueryV_3(RefundQueryBuilder builder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject requestData = builder.bothEncryptBuild();
        LOGGER.debug("CpPayOrderExecuter refundVQuery_3 requestData: {}", (Object)requestData);
        String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCpOnlinePayRefundQueryUrl(), requestData);
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        this.refundCallbackV_3(responseData, listener);
    }
}

