/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.ProductDetail;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public final class ReceiptOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String orderAmount;
    private String orderCurrency;
    private String requestId;
    private String notifyUrl;
    private String callbackUrl;
    private String remark;
    private String clientIp;
    private String agreementNo;
    private String walletId;
    private String userId;
    private String userFeeAmount;
    private String channelFlag;
    private String isNeedSms;
    private String cvv;
    private String expiredYear;
    private String expiredMonth;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();

    public ReceiptOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public ReceiptOrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public ReceiptOrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public ReceiptOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public ReceiptOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public ReceiptOrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public ReceiptOrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public ReceiptOrderBuilder setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public ReceiptOrderBuilder setAgreementNo(String agreementNo) {
        this.agreementNo = agreementNo;
        return this;
    }

    public ReceiptOrderBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public ReceiptOrderBuilder setUserFeeAmount(String userFeeAmount) {
        this.userFeeAmount = userFeeAmount;
        return this;
    }

    public ReceiptOrderBuilder setChannelFlag(String channelFlag) {
        this.channelFlag = channelFlag;
        return this;
    }

    public ReceiptOrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public ReceiptOrderBuilder setNeedSms(String needSms) {
        this.isNeedSms = needSms;
        return this;
    }

    public ReceiptOrderBuilder setCvv(String cvv) {
        this.cvv = cvv;
        return this;
    }

    public ReceiptOrderBuilder setExpiredYear(String expiredYear) {
        this.expiredYear = expiredYear;
        return this;
    }

    public ReceiptOrderBuilder setExpiredMonth(String expiredMonth) {
        this.expiredMonth = expiredMonth;
        return this;
    }

    public ReceiptOrderBuilder setWalletId(String walletId) {
        this.walletId = walletId;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

