/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.ert.v_3.v2.builder.BindCardBuilder;
import com.upay.sdk.ert.v_3.v2.builder.BindCardConfirmBuilder;
import com.upay.sdk.ert.v_3.v2.builder.BindCardQueryBuilder;
import com.upay.sdk.ert.v_3.v2.builder.UnBindCardBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindCardExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(BindCardExecuter.class);

    public void bothBindCard(BindCardBuilder builder, ResultListener resultListener) {
        block6: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("bindCard requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getErtBindCardUrlV2(), requestData);
                LOGGER.info("bindCard responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block6;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block6;
                }
                if (Constants.REDIRECT.equals(status)) {
                    resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                    break block6;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothBindCard error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothBindCardConfirm(BindCardConfirmBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("bindCardConfirm requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getErtBindCardConfirmUrlV2(), requestData);
                LOGGER.info("bindCardConfirm responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothBindCardConfirm error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothBindCardQuery(BindCardQueryBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("bindCardQuery requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getErtBindCardQueryUrlV2(), requestData);
                LOGGER.info("bindCardQuery responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothBindCardQuery error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothUnbindCard(UnBindCardBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("unbindCard requestData:[" + requestData.toJSONString() + "]");
                LOGGER.info("url:" + ConfigurationUtils.getErtUnBindCardUrlV2());
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getErtUnBindCardUrlV2(), requestData);
                LOGGER.debug("unbindCard responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.ERROR.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("bothUnbindCard error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothCipherCallback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(data);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

