/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.hg.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.ProductDetail;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class HgPayOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String payerMember;
    private String amount;
    private String currency;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();

    public HgPayOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public HgPayOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public HgPayOrderBuilder setPayerMember(String payerMember) {
        this.payerMember = payerMember;
        return this;
    }

    public HgPayOrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public HgPayOrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public void setProductDetails(List<ProductDetail> productDetails) {
        this.productDetails = productDetails;
    }

    public HgPayOrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.payerMember)) {
            json.put("payerMember", (Object)this.payerMember);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        json.put("productDetails", (Object)this.productDetails);
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.payerMember, (String)"")).append(StringUtils.defaultString((String)this.amount, (String)"")).append(StringUtils.defaultString((String)this.currency, (String)""));
        if (this.productDetails != null) {
            for (ProductDetail productDetail : this.productDetails) {
                hmacSource.append(StringUtils.defaultString((String)productDetail.getName())).append(ObjectUtils.defaultIfNull((Object)productDetail.getQuantity(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)productDetail.getAmount(), (Object)"")).append(StringUtils.defaultString((String)productDetail.getReceiver())).append(StringUtils.defaultString((String)productDetail.getDescription()));
            }
        }
        System.out.println("===========" + hmacSource.toString());
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

