/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_2.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;

public class JointaccountBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String email;
    private String phone;
    private String name;

    public JointaccountBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public JointaccountBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public JointaccountBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public JointaccountBuilder setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public JointaccountBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.email)) {
            json.put("email", (Object)this.email);
        }
        if (StringUtils.isNotBlank((CharSequence)this.phone)) {
            json.put("phone", (Object)this.phone);
        }
        if (StringUtils.isNotBlank((CharSequence)this.name)) {
            json.put("name", (Object)this.name);
        }
        return json;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

