/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.OrderSplitInfo;
import com.upay.sdk.entity.ProductDetail;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public final class NewRetailOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String amount;
    private String currency;
    private String requestId;
    private String notifyUrl;
    private String splitNotifyUrl;
    private String callbackUrl;
    private String guaranteeFlag;
    private String guaranteeTimeOut;
    private String remark;
    private String clientIp;
    private String splitMark;
    private String splitRule;
    private String delaySplit;
    private String userId;
    private String userName;
    private String idCardNo;
    private String paymentModeCode;
    private String agreementNo;
    private String guaranteeNotifyUrl;
    private String openId;
    private String appId;
    private String whether2Subsidize;
    private String subsidyAmount;
    private List<ProductDetail> productDetails = new LinkedList<ProductDetail>();
    private List<OrderSplitInfo> splitRecords = new LinkedList<OrderSplitInfo>();

    public NewRetailOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public NewRetailOrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public NewRetailOrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public NewRetailOrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public NewRetailOrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public NewRetailOrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public NewRetailOrderBuilder setGuaranteeFlag(String guaranteeFlag) {
        this.guaranteeFlag = guaranteeFlag;
        return this;
    }

    public NewRetailOrderBuilder setGuaranteeTimeOut(String guaranteeTimeOut) {
        this.guaranteeTimeOut = guaranteeTimeOut;
        return this;
    }

    public NewRetailOrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public NewRetailOrderBuilder setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public NewRetailOrderBuilder setSplitNotifyUrl(String splitNotifyUrl) {
        this.splitNotifyUrl = splitNotifyUrl;
        return this;
    }

    public NewRetailOrderBuilder setSplitMark(String splitMark) {
        this.splitMark = splitMark;
        return this;
    }

    public NewRetailOrderBuilder setSplitRule(String splitRule) {
        this.splitRule = splitRule;
        return this;
    }

    public NewRetailOrderBuilder setDelaySplit(String delaySplit) {
        this.delaySplit = delaySplit;
        return this;
    }

    public NewRetailOrderBuilder addProductDetail(ProductDetail productDetail) {
        this.productDetails.add(productDetail);
        return this;
    }

    public NewRetailOrderBuilder addSplitRecord(OrderSplitInfo splitRecord) {
        this.splitRecords.add(splitRecord);
        return this;
    }

    public NewRetailOrderBuilder setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public NewRetailOrderBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public NewRetailOrderBuilder setIdCardNo(String idCardNo) {
        this.idCardNo = idCardNo;
        return this;
    }

    public NewRetailOrderBuilder setPaymentModeCode(String paymentModeCode) {
        this.paymentModeCode = paymentModeCode;
        return this;
    }

    public NewRetailOrderBuilder setAgreementNo(String agreementNo) {
        this.agreementNo = agreementNo;
        return this;
    }

    public NewRetailOrderBuilder setGuaranteeNotifyUrl(String guaranteeNotifyUrl) {
        this.guaranteeNotifyUrl = guaranteeNotifyUrl;
        return this;
    }

    public NewRetailOrderBuilder setOpenId(String openId) {
        this.openId = openId;
        return this;
    }

    public NewRetailOrderBuilder setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public NewRetailOrderBuilder setWhether2Subsidize(String whether2Subsidize) {
        this.whether2Subsidize = whether2Subsidize;
        return this;
    }

    public NewRetailOrderBuilder setSubsidyAmount(String subsidyAmount) {
        this.subsidyAmount = subsidyAmount;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

