/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.SubsidyDetail;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public class NewRetailSubsidyBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String receiptOrderId;
    private String notifyUrl;
    private List<SubsidyDetail> subsidyDetails = new LinkedList<SubsidyDetail>();

    public NewRetailSubsidyBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public NewRetailSubsidyBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public NewRetailSubsidyBuilder setOrderId(String orderId) {
        this.receiptOrderId = orderId;
        return this;
    }

    public NewRetailSubsidyBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public NewRetailSubsidyBuilder addSplitRecord(SubsidyDetail subsidyDetail) {
        this.subsidyDetails.add(subsidyDetail);
        return this;
    }

    public NewRetailSubsidyBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

