/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.jointaccount.v_3.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.SubsidyRefundDetail;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public class NewRetailSubsidyRefundBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String receiptOrderId;
    private String notifyUrl;
    private String clientIp;
    private List<SubsidyRefundDetail> refundDetails = new LinkedList<SubsidyRefundDetail>();

    public NewRetailSubsidyRefundBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public NewRetailSubsidyRefundBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public NewRetailSubsidyRefundBuilder setReceiptOrderId(String receiptOrderId) {
        this.receiptOrderId = receiptOrderId;
        return this;
    }

    public NewRetailSubsidyRefundBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public NewRetailSubsidyRefundBuilder setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public NewRetailSubsidyRefundBuilder addRefundDetails(SubsidyRefundDetail refundDetail) {
        this.refundDetails.add(refundDetail);
        return this;
    }

    public NewRetailSubsidyRefundBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

