/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.phoenix.v_1.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;

public final class ReportBuilder
extends BuilderSupport {
    private String merchantId;
    private String signedName;
    private String merchantCode;
    private String email;
    private String provinceName;
    private String cityName;
    private String countyName;
    private String address;
    private String merchantType;
    private String businessLicenseNum;
    private String legalPersonName;
    private String legalPersonIdCardNum;
    private String linkName;
    private String linkMobile;
    private String linkEmail;
    private String weixinCategory;
    private String wxT1Fee;
    private String wxT0Fee;
    private String alipayCategory;
    private String alipayT1Fee;
    private String alipayT0Fee;
    private String accountType;
    private String accountName;
    private String bankNo;
    private String bankName;
    private String settleProvinceName;
    private String settleCityName;
    private String bankBranch;
    private String unionBankNo;
    private String creditCardNo;
    private String description;

    public ReportBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public ReportBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public ReportBuilder setSignedName(String signedName) {
        this.signedName = signedName;
        return this;
    }

    public ReportBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public ReportBuilder setProvinceName(String provinceName) {
        this.provinceName = provinceName;
        return this;
    }

    public ReportBuilder setCityName(String cityName) {
        this.cityName = cityName;
        return this;
    }

    public ReportBuilder setCountyName(String countyName) {
        this.countyName = countyName;
        return this;
    }

    public ReportBuilder setAddress(String address) {
        this.address = address;
        return this;
    }

    public ReportBuilder setMerchantType(String merchantType) {
        this.merchantType = merchantType;
        return this;
    }

    public ReportBuilder setBusinessLicenseNum(String businessLicenseNum) {
        this.businessLicenseNum = businessLicenseNum;
        return this;
    }

    public ReportBuilder setLegalPersonName(String legalPersonName) {
        this.legalPersonName = legalPersonName;
        return this;
    }

    public ReportBuilder setLegalPersonIdCardNum(String legalPersonIdCardNum) {
        this.legalPersonIdCardNum = legalPersonIdCardNum;
        return this;
    }

    public ReportBuilder setLinkName(String linkName) {
        this.linkName = linkName;
        return this;
    }

    public ReportBuilder setLinkMobile(String linkMobile) {
        this.linkMobile = linkMobile;
        return this;
    }

    public ReportBuilder setLinkEmail(String linkEmail) {
        this.linkEmail = linkEmail;
        return this;
    }

    public ReportBuilder setWeixinCategory(String weixinCategory) {
        this.weixinCategory = weixinCategory;
        return this;
    }

    public ReportBuilder setWxT1Fee(String wxT1Fee) {
        this.wxT1Fee = wxT1Fee;
        return this;
    }

    public ReportBuilder setWxT0Fee(String wxT0Fee) {
        this.wxT0Fee = wxT0Fee;
        return this;
    }

    public ReportBuilder setAlipayCategory(String alipayCategory) {
        this.alipayCategory = alipayCategory;
        return this;
    }

    public ReportBuilder setAlipayT1Fee(String alipayT1Fee) {
        this.alipayT1Fee = alipayT1Fee;
        return this;
    }

    public ReportBuilder setAlipayT0Fee(String alipayT0Fee) {
        this.alipayT0Fee = alipayT0Fee;
        return this;
    }

    public ReportBuilder setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public ReportBuilder setAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    public ReportBuilder setBankNo(String bankNo) {
        this.bankNo = bankNo;
        return this;
    }

    public ReportBuilder setBankName(String bankName) {
        this.bankName = bankName;
        return this;
    }

    public ReportBuilder setSettleProvinceName(String settleProvinceName) {
        this.settleProvinceName = settleProvinceName;
        return this;
    }

    public ReportBuilder setSettleCityName(String settleCityName) {
        this.settleCityName = settleCityName;
        return this;
    }

    public ReportBuilder setBankBranch(String bankBranch) {
        this.bankBranch = bankBranch;
        return this;
    }

    public ReportBuilder setUnionBankNo(String unionBankNo) {
        this.unionBankNo = unionBankNo;
        return this;
    }

    public ReportBuilder setCreditCardNo(String creditCardNo) {
        this.creditCardNo = creditCardNo;
        return this;
    }

    public ReportBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public ReportBuilder setMerchantCode(String merchantCode) {
        this.merchantCode = merchantCode;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.merchantId)) {
            json.put("merchantId", (Object)this.merchantId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.signedName)) {
            json.put("signedName", (Object)this.signedName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.merchantCode)) {
            json.put("merchantCode", (Object)this.merchantCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.email)) {
            json.put("email", (Object)this.email);
        }
        if (StringUtils.isNotBlank((CharSequence)this.provinceName)) {
            json.put("provinceName", (Object)this.provinceName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cityName)) {
            json.put("cityName", (Object)this.cityName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.countyName)) {
            json.put("countyName", (Object)this.countyName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.address)) {
            json.put("address", (Object)this.address);
        }
        if (StringUtils.isNotBlank((CharSequence)this.merchantType)) {
            json.put("merchantType", (Object)this.merchantType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.businessLicenseNum)) {
            json.put("businessLicenseNum", (Object)this.businessLicenseNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.legalPersonName)) {
            json.put("legalPersonName", (Object)this.legalPersonName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.legalPersonIdCardNum)) {
            json.put("legalPersonIdCardNum", (Object)this.legalPersonIdCardNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.linkName)) {
            json.put("linkName", (Object)this.linkName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.linkMobile)) {
            json.put("linkMobile", (Object)this.linkMobile);
        }
        if (StringUtils.isNotBlank((CharSequence)this.linkEmail)) {
            json.put("linkEmail", (Object)this.linkEmail);
        }
        if (StringUtils.isNotBlank((CharSequence)this.weixinCategory)) {
            json.put("weixinCategory", (Object)this.weixinCategory);
        }
        if (StringUtils.isNotBlank((CharSequence)this.wxT1Fee)) {
            json.put("wxT1Fee", (Object)this.wxT1Fee);
        }
        if (StringUtils.isNotBlank((CharSequence)this.wxT0Fee)) {
            json.put("wxT0Fee", (Object)this.wxT0Fee);
        }
        if (StringUtils.isNotBlank((CharSequence)this.alipayCategory)) {
            json.put("alipayCategory", (Object)this.alipayCategory);
        }
        if (StringUtils.isNotBlank((CharSequence)this.alipayT1Fee)) {
            json.put("alipayT1Fee", (Object)this.alipayT1Fee);
        }
        if (StringUtils.isNotBlank((CharSequence)this.alipayT0Fee)) {
            json.put("alipayT0Fee", (Object)this.alipayT0Fee);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountType)) {
            json.put("accountType", (Object)this.accountType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.accountName)) {
            json.put("accountName", (Object)this.accountName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankNo)) {
            json.put("bankNo", (Object)this.bankNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankName)) {
            json.put("bankName", (Object)this.bankName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.settleProvinceName)) {
            json.put("settleProvinceName", (Object)this.settleProvinceName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.settleCityName)) {
            json.put("settleCityName", (Object)this.settleCityName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.bankBranch)) {
            json.put("bankBranch", (Object)this.bankBranch);
        }
        if (StringUtils.isNotBlank((CharSequence)this.unionBankNo)) {
            json.put("unionBankNo", (Object)this.unionBankNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.creditCardNo)) {
            json.put("creditCardNo", (Object)this.creditCardNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            json.put("description", (Object)this.description);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.signedName, (String)"")).append(StringUtils.defaultString((String)this.merchantCode, (String)"")).append(StringUtils.defaultString((String)this.email, (String)"")).append(StringUtils.defaultString((String)this.provinceName, (String)"")).append(StringUtils.defaultString((String)this.cityName, (String)"")).append(StringUtils.defaultString((String)this.countyName, (String)"")).append(StringUtils.defaultString((String)this.address, (String)"")).append(StringUtils.defaultString((String)this.merchantType, (String)"")).append(StringUtils.defaultString((String)this.businessLicenseNum, (String)"")).append(StringUtils.defaultString((String)this.legalPersonName, (String)"")).append(StringUtils.defaultString((String)this.legalPersonIdCardNum, (String)"")).append(StringUtils.defaultString((String)this.linkName, (String)"")).append(StringUtils.defaultString((String)this.linkMobile, (String)"")).append(StringUtils.defaultString((String)this.linkEmail, (String)"")).append(StringUtils.defaultString((String)this.weixinCategory, (String)"")).append(StringUtils.defaultString((String)this.wxT1Fee, (String)"")).append(StringUtils.defaultString((String)this.wxT0Fee, (String)"")).append(StringUtils.defaultString((String)this.alipayCategory, (String)"")).append(StringUtils.defaultString((String)this.alipayT1Fee, (String)"")).append(StringUtils.defaultString((String)this.alipayT0Fee, (String)"")).append(StringUtils.defaultString((String)this.accountType, (String)"")).append(StringUtils.defaultString((String)this.accountName, (String)"")).append(StringUtils.defaultString((String)this.bankNo, (String)"")).append(StringUtils.defaultString((String)this.bankName, (String)"")).append(StringUtils.defaultString((String)this.settleProvinceName, (String)"")).append(StringUtils.defaultString((String)this.bankBranch, (String)"")).append(StringUtils.defaultString((String)this.unionBankNo, (String)"")).append(StringUtils.defaultString((String)this.creditCardNo, (String)"")).append(StringUtils.defaultString((String)this.description, (String)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }
}

