/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.prepaycard.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.NonBankCard;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String amount;
    private String currency;
    private String requestId;
    private String notifyUrl;
    private String callbackUrl;
    private String remark;
    private String cardType;
    private String clientIp;
    private List<NonBankCard> nonBankCards = new LinkedList<NonBankCard>();

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public OrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setCardType(String cardType) {
        this.cardType = cardType;
        return this;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public OrderBuilder addNonBankCard(NonBankCard nonBankCard) {
        this.nonBankCards.add(nonBankCard);
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.currency)) {
            json.put("currency", (Object)this.currency);
        }
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.callbackUrl)) {
            json.put("callbackUrl", (Object)this.callbackUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cardType)) {
            json.put("cardType", (Object)this.cardType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.clientIp)) {
            json.put("clientIp", (Object)this.clientIp);
        }
        json.put("nonBankCards", (Object)this.nonBankCards);
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append((String)ObjectUtils.defaultIfNull((Object)this.amount, (Object)"")).append(StringUtils.defaultString((String)this.currency, (String)"")).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)"")).append(StringUtils.defaultString((String)this.callbackUrl, (String)"")).append(StringUtils.defaultString((String)this.remark, (String)"")).append(StringUtils.defaultString((String)this.cardType, (String)""));
        hmacSource.append(StringUtils.defaultString((String)this.clientIp, (String)""));
        if (this.nonBankCards != null) {
            for (NonBankCard nonBankCard : this.nonBankCards) {
                hmacSource.append(StringUtils.defaultString((String)nonBankCard.getCardNo())).append((String)ObjectUtils.defaultIfNull((Object)nonBankCard.getCardPassword(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)nonBankCard.getAmount(), (Object)""));
            }
        }
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        System.out.println("sdk \u7b7e\u540d :" + super.orderGenerateHmac());
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

