/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.qc.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.StringUtils;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String mobileNum;
    private String amount;
    private String notifyUrl;
    private String remark;
    private String tradePassCode;

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setMobileNum(String mobileNum) {
        this.mobileNum = mobileNum;
        return this;
    }

    public OrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setTradePassCode(String tradePassCode) {
        this.tradePassCode = tradePassCode;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.mobileNum)) {
            json.put("mobileNum", (Object)this.mobileNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.amount)) {
            json.put("amount", (Object)this.amount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        if (StringUtils.isNotBlank((CharSequence)this.remark)) {
            json.put("remark", (Object)this.remark);
        }
        if (StringUtils.isNotBlank((CharSequence)this.tradePassCode)) {
            json.put("tradePassCode", (Object)this.tradePassCode);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(this.merchantId).append(this.requestId).append(this.mobileNum).append(this.amount).append(this.notifyUrl).append(this.remark).append(this.tradePassCode);
        System.out.println("===========" + hmacSource.toString());
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

