/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.serviceprovider.v3_0.declaration.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.BankCardInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.BaseInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.CertificateContacts;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.CertificateInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.ContractInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.DesireAuthInfo;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.PaymentProfile;
import com.upay.sdk.serviceprovider.v3_0.declaration.entity.SettlementProfile;
import java.util.List;

public class DeclarationBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String operationType;
    private String notifyUrl;
    private BaseInfo baseInfo;
    private BankCardInfo bankCardInfo;
    private DesireAuthInfo desireAuthInfo;
    private CertificateInfo certificateInfo;
    private List<CertificateContacts> certificateContacts;
    private ContractInfo contractInfo;
    private List<PaymentProfile> paymentProfiles;
    private SettlementProfile settlementProfile;
    private String extendedParameters;

    public DeclarationBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public BaseInfo getBaseInfo() {
        return this.baseInfo;
    }

    public void setBaseInfo(BaseInfo baseInfo) {
        this.baseInfo = baseInfo;
    }

    public BankCardInfo getBankCardInfo() {
        return this.bankCardInfo;
    }

    public void setBankCardInfo(BankCardInfo bankCardInfo) {
        this.bankCardInfo = bankCardInfo;
    }

    public DesireAuthInfo getDesireAuthInfo() {
        return this.desireAuthInfo;
    }

    public void setDesireAuthInfo(DesireAuthInfo desireAuthInfo) {
        this.desireAuthInfo = desireAuthInfo;
    }

    public CertificateInfo getCertificateInfo() {
        return this.certificateInfo;
    }

    public void setCertificateInfo(CertificateInfo certificateInfo) {
        this.certificateInfo = certificateInfo;
    }

    public List<CertificateContacts> getCertificateContacts() {
        return this.certificateContacts;
    }

    public void setCertificateContacts(List<CertificateContacts> certificateContacts) {
        this.certificateContacts = certificateContacts;
    }

    public ContractInfo getContractInfo() {
        return this.contractInfo;
    }

    public void setContractInfo(ContractInfo contractInfo) {
        this.contractInfo = contractInfo;
    }

    public List<PaymentProfile> getPaymentProfiles() {
        return this.paymentProfiles;
    }

    public void setPaymentProfiles(List<PaymentProfile> paymentProfiles) {
        this.paymentProfiles = paymentProfiles;
    }

    public SettlementProfile getSettlementProfile() {
        return this.settlementProfile;
    }

    public void setSettlementProfile(SettlementProfile settlementProfile) {
        this.settlementProfile = settlementProfile;
    }

    public String getExtendedParameters() {
        return this.extendedParameters;
    }

    public void setExtendedParameters(String extendedParameters) {
        this.extendedParameters = extendedParameters;
    }
}

