/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.transfer.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.Payee;
import com.upay.sdk.exception.UnknownException;

public class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String currency;
    private String creditedCurrency;
    private String amount;
    private String transferMode;
    private String singleReceiveAccount;
    private String isMerger;
    private String contractPath;
    private String detailPath;
    private String notifyUrl;
    private String callbackUrl;
    private String listpriceToken;
    private Payee payee;
    private String validateId;
    private String transferBusinessType;

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setAmount(String amount) {
        this.amount = amount;
        return this;
    }

    public OrderBuilder setCurrency(String currency) {
        this.currency = currency;
        return this;
    }

    public OrderBuilder setCreditedCurrency(String creditedCurrency) {
        this.creditedCurrency = creditedCurrency;
        return this;
    }

    public OrderBuilder setTransferMode(String transferMode) {
        this.transferMode = transferMode;
        return this;
    }

    public OrderBuilder setSingleReceiveAccount(String singleReceiveAccount) {
        this.singleReceiveAccount = singleReceiveAccount;
        return this;
    }

    public OrderBuilder setIsMerger(String isMerger) {
        this.isMerger = isMerger;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OrderBuilder setContractPath(String contractPath) {
        this.contractPath = contractPath;
        return this;
    }

    public OrderBuilder setDetailPath(String detailPath) {
        this.detailPath = detailPath;
        return this;
    }

    public void setListpriceToken(String listpriceToken) {
        this.listpriceToken = listpriceToken;
    }

    public OrderBuilder setPayee(Payee payee) {
        this.payee = payee;
        return this;
    }

    public OrderBuilder setTransferBusinessType(String transferBusinessType) {
        this.transferBusinessType = transferBusinessType;
        return this;
    }

    public OrderBuilder setValidateId(String validateId) {
        this.validateId = validateId;
        return this;
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = this.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

