/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.withholding.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import org.apache.commons.lang3.StringUtils;

public class QueryBuilder
extends BuilderSupport {
    private String merchantId;
    private String language;
    private String requestId;
    private String orderRequestId;

    public QueryBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public QueryBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public QueryBuilder setOrderRequestId(String orderRequestId) {
        this.orderRequestId = orderRequestId;
        return this;
    }

    public QueryBuilder setLanguage(String language) {
        this.language = language;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.orderRequestId)) {
            json.put("orderRequestId", (Object)this.orderRequestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.language)) {
            json.put("language", (Object)this.language);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId)).append(StringUtils.defaultString((String)this.language)).append(StringUtils.defaultString((String)this.orderRequestId));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }
}

