/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.withholding.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WithholdingOrderExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(WithholdingOrderExecuter.class);
    static final String[] ORDER_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, Constants.STATUS, "errorCode", "errorMessage", "redirectUrl"};
    static final String[] QUERY_RESPONSE_HMAC_FIELDS = new String[]{Constants.MERCHANT_ID, Constants.REQUEST_ID, "orderRequestId", "serialNumber", "amount", "currency", Constants.STATUS, "completeDateTime", "debitAmount", "debitCurrency", "remark", "errorCode", "errorMessage", "createDateTime"};

    public void orderBatch(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getWithholdingOrderBatchUrl(), requestData.toJSONString(), requestData.getString("language"));
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        if (responseData != null && !requestData.equals("")) {
            this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) {
                throw new ResponseException(responseData);
            }
        } else {
            throw new NullPointerException("responseData is null");
        }
        resultListener.success(responseData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void order(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getWithholdingOrderUrl(), requestData.toJSONString(), requestData.getString("language"));
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        if (responseData == null || requestData.equals("")) throw new NullPointerException("responseData is null");
        this.verifyHmac(ORDER_RESPONSE_HMAC_FIELDS, responseData);
        if (Constants.REDIRECT.equals(responseData.getString(Constants.STATUS))) {
            try {
                resultListener.redirect(responseData, responseData.getString("redirectUrl"));
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return;
        } else {
            if (!Constants.SUCCESS.equals(responseData.getString(Constants.STATUS))) throw new ResponseException(responseData);
            resultListener.success(responseData);
        }
    }

    public void query(JSONObject requestData, ResultListener resultListener) {
        LOGGER.debug("requestData:[" + requestData.toJSONString() + "]");
        String responseStr = HttpClientUtils.post(ConfigurationUtils.getWithholdingQueryUrl(), requestData.toJSONString(), requestData.getString("language"));
        LOGGER.debug("responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        if (responseData == null || requestData.equals("")) {
            throw new NullPointerException("responseData is null");
        }
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        resultListener.success(responseData);
    }

    public void callback(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.verifyHmac(QUERY_RESPONSE_HMAC_FIELDS, responseData);
        String status = responseData.getString(Constants.STATUS);
        if (status != null && !status.equals("")) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(responseData);
            } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
                listener.failure(responseData);
            } else if (Constants.INIT.equals(status)) {
                listener.pending(responseData);
            } else {
                throw new ResponseException(responseData);
            }
        }
    }
}

