/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastle.by_1_52.crypto.BasicAgreement;
import org.bouncycastle.by_1_52.crypto.CipherParameters;
import org.bouncycastle.by_1_52.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.by_1_52.crypto.params.DHParameters;
import org.bouncycastle.by_1_52.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.by_1_52.crypto.params.DHPublicKeyParameters;
import org.bouncycastle.by_1_52.crypto.params.ParametersWithRandom;

public class DHBasicAgreement
implements BasicAgreement {
    private DHPrivateKeyParameters key;
    private DHParameters dhParams;

    @Override
    public void init(CipherParameters param) {
        AsymmetricKeyParameter kParam;
        if (param instanceof ParametersWithRandom) {
            ParametersWithRandom rParam = (ParametersWithRandom)param;
            kParam = (AsymmetricKeyParameter)rParam.getParameters();
        } else {
            kParam = (AsymmetricKeyParameter)param;
        }
        if (!(kParam instanceof DHPrivateKeyParameters)) {
            throw new IllegalArgumentException("DHEngine expects DHPrivateKeyParameters");
        }
        this.key = (DHPrivateKeyParameters)kParam;
        this.dhParams = this.key.getParameters();
    }

    @Override
    public int getFieldSize() {
        return (this.key.getParameters().getP().bitLength() + 7) / 8;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters pubKey) {
        DHPublicKeyParameters pub = (DHPublicKeyParameters)pubKey;
        if (!pub.getParameters().equals(this.dhParams)) {
            throw new IllegalArgumentException("Diffie-Hellman public key has wrong parameters.");
        }
        return pub.getY().modPow(this.key.getX(), this.dhParams.getP());
    }
}

