/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.by_1_52.crypto.util;

import java.io.IOException;
import org.bouncycastle.by_1_52.asn1.ASN1Encodable;
import org.bouncycastle.by_1_52.asn1.ASN1Integer;
import org.bouncycastle.by_1_52.asn1.DERNull;
import org.bouncycastle.by_1_52.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.by_1_52.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.by_1_52.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.by_1_52.asn1.sec.ECPrivateKey;
import org.bouncycastle.by_1_52.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.by_1_52.asn1.x509.DSAParameter;
import org.bouncycastle.by_1_52.asn1.x9.X962Parameters;
import org.bouncycastle.by_1_52.asn1.x9.X9ECParameters;
import org.bouncycastle.by_1_52.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.by_1_52.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.by_1_52.crypto.params.DSAParameters;
import org.bouncycastle.by_1_52.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.by_1_52.crypto.params.ECDomainParameters;
import org.bouncycastle.by_1_52.crypto.params.ECNamedDomainParameters;
import org.bouncycastle.by_1_52.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.by_1_52.crypto.params.RSAKeyParameters;
import org.bouncycastle.by_1_52.crypto.params.RSAPrivateCrtKeyParameters;

public class PrivateKeyInfoFactory {
    public static PrivateKeyInfo createPrivateKeyInfo(AsymmetricKeyParameter privateKey) throws IOException {
        if (privateKey instanceof RSAKeyParameters) {
            RSAPrivateCrtKeyParameters priv = (RSAPrivateCrtKeyParameters)privateKey;
            return new PrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.rsaEncryption, DERNull.INSTANCE), new RSAPrivateKey(priv.getModulus(), priv.getPublicExponent(), priv.getExponent(), priv.getP(), priv.getQ(), priv.getDP(), priv.getDQ(), priv.getQInv()));
        }
        if (privateKey instanceof DSAPrivateKeyParameters) {
            DSAPrivateKeyParameters priv = (DSAPrivateKeyParameters)privateKey;
            DSAParameters params = priv.getParameters();
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(params.getP(), params.getQ(), params.getG())), new ASN1Integer(priv.getX()));
        }
        if (privateKey instanceof ECPrivateKeyParameters) {
            int orderBitLength;
            X962Parameters params;
            ECPrivateKeyParameters priv = (ECPrivateKeyParameters)privateKey;
            ECDomainParameters domainParams = priv.getParameters();
            if (domainParams == null) {
                params = new X962Parameters(DERNull.INSTANCE);
                orderBitLength = priv.getD().bitLength();
            } else if (domainParams instanceof ECNamedDomainParameters) {
                params = new X962Parameters(((ECNamedDomainParameters)domainParams).getName());
                orderBitLength = domainParams.getCurve().getOrder().bitLength();
            } else {
                X9ECParameters ecP = new X9ECParameters(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                params = new X962Parameters(ecP);
                orderBitLength = domainParams.getCurve().getOrder().bitLength();
            }
            return new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), new ECPrivateKey(orderBitLength, priv.getD(), (ASN1Encodable)params));
        }
        throw new IOException("key parameters not recognised.");
    }
}

