/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.spv;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;

public class WorldStateNode
extends MychainObject {
    private byte[] data;
    private int beginIndex;
    private int endIndex;

    public WorldStateNode(byte[] data, int beginIndex, int endIndex) {
        this.data = data;
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public WorldStateNode() {
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public void setBeginIndex(int beginIndex) {
        this.beginIndex = beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        this.endIndex = endIndex;
    }

    @Override
    public byte[] toRlp() {
        byte[] dataBytes = Rlp.encodeElement(this.data);
        byte[] beginIndexBytes = Rlp.encodeInt(this.beginIndex);
        byte[] endIndexBytes = Rlp.encodeInt(this.endIndex);
        return Rlp.encodeList(dataBytes, beginIndexBytes, endIndexBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.data = ((RlpElement)list.get(0)).getRlpData();
        this.beginIndex = ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData());
        this.endIndex = ByteUtils.byteArrayToInt(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("data", (Object)ByteUtils.toHexString(this.data));
        jsonObject.put("next_key_begin_index", (Object)this.beginIndex);
        jsonObject.put("next_key_end_index", (Object)this.endIndex);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.data = ByteUtils.hexStringToBytes(jsonObject.getString("data"));
        this.beginIndex = jsonObject.getIntValue("next_key_begin_index");
        this.endIndex = jsonObject.getIntValue("next_key_end_index");
    }
}

