/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.domain.status;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.domain.MychainObject;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;

public class SyncStatus
extends MychainObject {
    private int syncing;
    private BigInteger myBest;
    private BigInteger target;

    public static SyncStatus builder(int syncing, BigInteger myBest, BigInteger target) {
        SyncStatus syncStatus = new SyncStatus();
        syncStatus.syncing = syncing;
        syncStatus.myBest = myBest;
        syncStatus.target = target;
        return syncStatus;
    }

    public int getSyncing() {
        return this.syncing;
    }

    public BigInteger getMyBest() {
        return this.myBest;
    }

    public BigInteger getTarget() {
        return this.target;
    }

    @Override
    public byte[] toRlp() {
        byte[] syncingBytes = Rlp.encodeInt(this.syncing);
        byte[] myBestBytes = Rlp.encodeBigInteger(this.myBest);
        byte[] targetBytes = Rlp.encodeBigInteger(this.target);
        return Rlp.encodeList(syncingBytes, myBestBytes, targetBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        this.syncing = ByteUtils.byteArrayToInt(((RlpElement)list.get(0)).getRlpData());
        this.myBest = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
        this.target = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(2)).getRlpData());
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        jsonObject.put("syncing", (Object)this.syncing);
        jsonObject.put("my_best", (Object)this.myBest);
        jsonObject.put("target", (Object)this.target);
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        this.syncing = jsonObject.getIntValue("syncing");
        this.myBest = jsonObject.getBigInteger("my_best");
        this.target = jsonObject.getBigInteger("target");
    }
}

