/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.errorcode;

import com.alipay.mychain.sdk.errorcode.IErrorCode;

public enum ErrorCode implements IErrorCode
{
    SUCCESS(0, "SUCCESS"),
    INVALID_MEMORY(10, "invalid memory"),
    BAD_HASH(100, "the hash is not correctly computed"),
    TX_IS_NULL(101, "the tx pointer is nullptr"),
    TX_PAYLOAD_INVALID(102, "the data of tx does not satisfy type constraint"),
    TX_INVALID_SIGNATURE(103, "the signature is not valid"),
    TX_INSUFFICIENT_BALANCE(104, "the sender of tx doesn't have enough money"),
    TX_INVALID_TIMESTAMP(105, "the timestamp of tx is not in valid period"),
    TX_INVALID_DEST_ACCOUNT(106, "the dest account of tx doesn't have contract hash"),
    TX_DEST_ACCOUNT_IS_NULL(107, "the dest account of tx is empty"),
    TX_CREATE_ACCOUNT_INVALID(108, "the create account tx doesn't satisfy requirement"),
    TX_DEPLOY_CONTRACT_INVALID(109, "the deploy contract tx doesn't satisfy requirement"),
    TX_TYPE_CONSTRAINT_INVALID(110, "basic tx type requirement verify failed"),
    TX_TYPE_UNKNOWN(111, "the type of tx is unknown"),
    TX_RECOVER_TIME_INVALID(112, "the recover time is invalid"),
    TX_REPLAY_ATTACK(113, "the tx is replayed"),
    TX_PAYLOAD_TOO_BIG(114, "the data of tx is too big, beyond system constraint"),
    TX_GAS_TOO_BIG(115, "the gas if tx is too big, beyond system constraint"),
    TX_SOURCE_ACCOUNT_NOT_FOUND(116, "the source account of tx doesn't exists in blockchain"),
    TX_SOURCE_ACCOUNT_IS_NULL(117, "the source account of tx is empty"),
    TX_SOURCE_ACCOUNT_IS_FREEZE(118, "the source account of tx is frozen"),
    TX_SOURCE_ACCOUNT_IS_RECOVERING(119, "the source account of tx is recovering"),
    TX_DEST_ACCOUNT_NOT_FOUND(120, "the dest account of tx doesn't exit in blockchain"),
    TX_DEST_ACCOUNT_IS_FREEZE(121, "the dest account of tx is frozen"),
    TX_INVALID_PERMISSION(122, "the signature of tx is not enough"),
    TX_DEST_ACCOUNT_ALREADY_EXIST(123, "the dest account of tx already exist"),
    BLOCK_IS_NULL(124, "block pointer is nullptr"),
    BLOCK_PARENT_NOT_FOUND(125, "the parent of block doesn't exist"),
    BLOCK_INVALID_PARENT(126, "the parent of block is invalid because of hash and block number doesn't match"),
    BLOCK_INVALID_TIMESTAMP(127, "the timestamp of block doesn't satisfy monotonically increasing requirement"),
    BLOCK_BAD_TX_ROOT(128, "the tx root hash of block is not correctly computed"),
    BLOCK_BAD_TX_RECEIPT_ROOT(129, "the tx receipt root hash of block is not correctly computed"),
    BLOCK_INVALID_CONSENSUS_PROOF(130, "the consensus proof oh block is invalid"),
    OTHERS(131, "others error"),
    TX_INVALID_GROUP_ID(132, "group id constraint is not satisfied"),
    TX_INVALID_VERSION(133, "tx version constraint is not satisfied"),
    TX_ACCOUNT_IS_NULL(134, "account is null"),
    TX_CONTRACT_IS_NULL(135, "contract is null"),
    SERVICE_PLUGIN_NOT_EXISTS(400, "plugin not exists"),
    SERVICE_MSG_CONVERT_FAILED(401, "msg convert failed"),
    SERVICE_RUN_LOCAL_TX_FAILED(402, "exec local tx failed"),
    SERVICE_PUSH_CACHE_FAILED(403, "push tx to cache failed"),
    SERVICE_QUERY_NO_RESULT(404, "query msg no result"),
    SERVICE_NOT_SUPPORT(405, "service not support"),
    SERVICE_EVENT_NOT_EXISTS(406, "event not exists"),
    SERVICE_LOG_INSTANCE_NOT_EXISTS(407, "log instance not exists"),
    SERVICE_TX_VERIFY_FAILED(408, "transaction verify failed"),
    SERVICE_FORWARD_NO_NODEID(409, "no node to forward"),
    SERVICE_FORWARD_TIMEOUT(410, " forward request timeout"),
    SERVICE_FORWARD_RESPONSE_ERROR(411, " forward response error"),
    SERVICE_ADD_GROUP_CHAIN_FAILED(412, "add group chain failed"),
    SERVICE_TX_WAITING_VERIFY(413, "tx is pending to verify"),
    SERVICE_TX_WAITING_EXECUTE(414, "tx is verified, waiting to be executed"),
    SERVICE_CHAIN_OUT_OF_SERVICE(415, "chain is out of service, can not generate new block"),
    SERVICE_TIMESTAMP_TOO_SMALL(416, "ts is smaller than genesis block, used for quering block header by ts"),
    SERVICE_FORWARD_QUERY_NO_RESULT(417, "forward query no result"),
    SERVICE_REGISTER_EVENT_FAILED(418, "failed to register an event"),
    SERVICE_INVALID_PARAMETER(419, "input parameter is invalid"),
    SERVICE_INVALID_PERMISSION(420, "input is allowed to execute operation"),
    SERVICE_INTERNAL_ERROR(421, "service internal error"),
    WS_NO_DATABASE_FAILED(1000, "ws database is not Initialized"),
    WS_NO_CODE_HASH_FAILED(1001, "ws failed to find the code hash for the congtract"),
    WS_NO_OBJECT_FAILED(1002, "the state object is not found from the world state"),
    WS_OBJECT_EXIST_FAILED(1003, "the state object (id) is occupied"),
    WS_OBJECT_DELETED_FAILED(1004, "the given state object (id) has been deleled"),
    WS_NO_ENOUGH_BALANCE_FAILED(1005, "the given state object doesn't have enough balance"),
    WS_TRANSFER_FAILED(1006, "failed to transfer balance"),
    WS_AUTH_NO_PUB_KEY_FAILED(1007, "the given public key doesn't exist from auth map"),
    WS_BALANCE_OVERFLOW_FAILED(1008, "balance overfloaw"),
    WS_UNKNOWN_FAILED(1009, "unknown failure from"),
    WS_INVALID_AUTH_MAP_FAILED(1010, "the given auth map is invalid"),
    WS_KEY_NOT_FOUND(1011, "the given key doesn't exists in world state"),
    CHAIN_TX_GAS_INVALID(2000, "the transaction runner can't get enough gas from the tx"),
    CHAIN_TX_IDENTITY_INVALID(2001, "the transaction runner can't locate teh identity from the chain"),
    CHAIN_TX_AUTH_MAP_INVALID(2002, "the auth map in the payload is invalid"),
    CHAIN_TX_PAYLOAD_INVALID(2003, "the payload of transaction is invalid"),
    CHAIN_TX_RECOVER_INVALID(2004, "invalid recover time"),
    CHAIN_TX_INSIDE_ERROR(2005, "unknown error from transaction runner"),
    STORAGE_BLOCK_NOT_FOUND(3000, "block not exists"),
    STORAGE_NO_DB(3001, "no db"),
    STORAGE_WRITEDB_FAILED(3002, "write db failed"),
    STORAGE_READDB_FAILED(3003, "read db failed"),
    STORAGE_PARSE_RLP_FAILED(3004, "parse rlp failed"),
    STORAGE_ID_INVALID(3005, "id invalid"),
    STORAGE_CURRENTDB_STATEROOT_INVALID(3006, "current db state root invalid"),
    STORAGE_SETROOT_FAILED(3007, "set root failed"),
    STORAGE_CURRENTDB_LOST(3008, "current db lost"),
    STORAGE_RECOVERY_FAILED(3009, "recovery failed"),
    STORAGE_CURRENTWS_NULL(3010, "current ws null"),
    STORAGE_LASTBLOCK_NULL(3011, "last block null"),
    STORAGE_BLOCKNUMBER_INVALID(3012, "block number invalid"),
    STORAGE_SNAPSHORT_FAILED(3013, "snapshot failed"),
    VM_GENERIC_FAILED(10000, "the general failure"),
    VM_INVALID_INSTRUCTION(10001, "for bad instruction "),
    VM_STACK_OVERFLOW(10002, "for adjust stack"),
    VM_STACK_UNDERFLOW(10003, "for adjust stack"),
    VM_MEMORY_ERROR(10004, "memory error"),
    VM_EMPTY_CODE(10005, "empty code"),
    VM_FORCE_REDO(10006, "force redo"),
    VM_CONFIG_OVER_GAS_LIMIT(10100, "vm execute max gas limit"),
    VM_CREATE_FAILED(10101, "vm create failure."),
    VM_PARAMETER_CODE_EMPTY_FAILED(10102, "vm prarameter code empty"),
    VM_PARAMETER_INPUT_DATA_EMPTY_FAILED(10103, "vm prarameter code empty"),
    VM_OUT_OF_GAS(10200, "out of gas"),
    VM_REVERT(10201, "caused by revert instruction"),
    VM_OUT_OF_LIMIT(10202, "caused by toUint64 method"),
    VM_DISALLOWED_STATE_CHANGE(10203, "caused by the vmcontext->is_static_call ( true;"),
    VM_METHOD_NOT_EXIST(10204, "caused by the vm method is wrong"),
    VM_PARAMETER_NOT_MATCH(10205, "caused by vm parameter not match"),
    VM_GET_BALANCE_FAILED(10300, "get balance from world state fail ."),
    VM_SET_STORAGE_FAILED(10301, "set storage fail  ( 108, common caused by sstore"),
    VM_GET_STORAGE_FAILED(10302, "get storage fail  ( 108, common caused by sload"),
    VM_TRANSFER_BALANCE_FAILED(10303, "transfer balance fail  ( 108,common caused by evm_call->call method"),
    VM_GET_CODE_FAILED(10304, "getcode fail , common caused by extcodecopy/extcodesize instruction or evm_call->call method"),
    VM_GET_BLOCKHASH_FAILED(10305, "get block hash fail, caused by block hash instruction"),
    VM_GET_CODEHASH_FAILED(10306, " get codehash fail, caused by user not exist "),
    VM_GET_GASLIMIT_FAILED(10307, "get gas limit failed, set by genesis.json"),
    VM_DELETE_STORAGE_FAILED(10308, "delete storage failed, caused by client receive delete storage result failed"),
    VM_INTERNAL_ERROR(10500, "vm internal error"),
    VM_CREATE_FILE_FAILED(10600, "native contract create dynamic lib fail"),
    VM_CREATE_SOCKET_FAILED(10601, "native contract create socket fail"),
    VM_BIND_FAILED(10602, "native contract bind socket fail"),
    VM_LISTEN_FAILED(10603, "native contract listen socket fail"),
    VM_ACCEPT_FAILED(10604, "native contract accept socket fail"),
    VM_READ_DATA_FAILED(10605, "native contract read data fail"),
    VM_EXECUTE_CLIENT_FAILED(10606, "native contract execute the child process to run the client"),
    VM_FORK_FAILED(10607, "native contract fork process fail"),
    VM_WRITE_DATA_FAILED(10608, "native write data fail"),
    VM_NOT_FAILED(10620, "native contract not support"),
    VM_INIT_FAILED(10622, "native contract startup failed"),
    VM_DEPLOY_FAILED(10623, "vm deploy failed, may be caused by native contract deploy the code"),
    VM_RESPONSE_FAILED(10624, "vm response failed, may be caused by native contract response the data to client"),
    VM_PRECOMPILE_NOT_FAILED(10700, "vm not support native precompile contract, no build with ENABLE_NATIVE_PRECOMPILE_CONTRACT"),
    VM_PRECOMPILE_INIT_FAILED(10701, "vm startup failed, may be caused by native precompile contract startup method"),
    VM_PRECOMPILE_DEPLOY_FAILED(10702, "vm deploy failed, may be caused by native precompile contract deploy the code"),
    VM_PRECOMPILE_RESPONSE_FAILED(10703, "vm response failed, may be caused by native precompile contract response the data to client"),
    PROPERTY_ARGS_FORMAT(10900, "property args format"),
    PROPERTY_PATH_NOT_EXIST(10901, "property path not exist"),
    PROPERTY_HANDLER_NOT_EXIST(10902, "property handler not exist"),
    PROPERTY_NODE_TYPE_NOT_MATCH(10903, "property node type not match"),
    SDK_INTERNAL_ERROR(20000, "sdk internal error"),
    SDK_ADDRESS_FAMILY_NOT_SUPPORTED(20001, "sdk address family not supported"),
    SDK_ADDRESS_IN_USE(20002, "sdk address in use"),
    SDK_ADDRESS_NOT_AVAILABLE(20003, "sdk address not available"),
    SDK_ALREADY_CONNECTED(20004, "sdk already connected"),
    SDK_ARGUMENT_LIST_TOO_LONG(20005, "sdk argument list too long"),
    SDK_ARGUMENT_OUT_OF_DOMAIN(20006, "sdk argument out of domain"),
    SDK_BAD_ADDRESS(20007, "sdk bad address"),
    SDK_BAD_FILE_DESCRIPTOR(20008, "sdk bad file descriptor"),
    SDK_BAD_MESSAGE(20009, "sdk bad message"),
    SDK_BROKEN_PIPE(20010, "sdk broken pipe"),
    SDK_CONNECTION_ABORTED(20011, "sdk connection aborted"),
    SDK_CONNECTION_ALREADY_IN_PROGRESS(20012, "sdk connection already in progress"),
    SDK_CONNECTION_REFUSED(20013, "sdk connection refused"),
    SDK_CONNECTION_RESET(20014, "sdk connection reset"),
    SDK_CROSS_DEVICE_LINK(20015, "sdk cross device link"),
    SDK_DESTINATION_ADDRESS_REQUIRED(20016, "sdk destination address required"),
    SDK_DEVICE_OR_RESOURCE_BUSY(20017, "sdk device or resource busy"),
    SDK_DIRECTORY_NOT_EMPTY(20018, "sdk directory not empty"),
    SDK_EXECUTABLE_FORMAT_ERROR(20019, "sdk executable format error"),
    SDK_FILE_EXISTS(20020, "sdk file exists"),
    SDK_FILE_TOO_LARGE(20021, "sdk file too large"),
    SDK_FILENAME_TOO_LONG(20022, "sdk filename too long"),
    SDK_FUNCTION_NOT_SUPPORTED(20023, "sdk function not supported"),
    SDK_HOST_UNREACHABLE(20024, "sdk host unreachable"),
    SDK_IDENTIFIER_REMOVED(20025, "sdk identifier removed"),
    SDK_ILLEGAL_BYTE_SEQUENCE(20026, "sdk illegal byte sequence"),
    SDK_INAPPROPRIATE_IO_CONTROL_OPERATION(20027, "sdk inappropriate io control operation"),
    SDK_INTERRUPTED(20028, "sdk interrupted"),
    SDK_INVALID_ARGUMENT(20029, "sdk invalid argument"),
    SDK_INVALID_SEEK(20030, "sdk invalid seek"),
    SDK_IO_ERROR(20031, "sdk io error"),
    SDK_IS_A_DIRECTORY(20032, "sdk is a directory"),
    SDK_MESSAGE_SIZE(20033, "sdk message size"),
    SDK_NETWORK_DOWN(20034, "sdk network down"),
    SDK_NETWORK_RESET(20035, "sdk network reset"),
    SDK_NETWORK_UNREACHABLE(20036, "sdk network unreachable"),
    SDK_NO_BUFFER_SPACE(20037, "sdk no buffer space"),
    SDK_NO_CHILD_PROCESS(20038, "sdk no child process"),
    SDK_NO_LINK(20039, "sdk no link"),
    SDK_NO_LOCK_AVAILABLE(20040, "sdk no lock available"),
    SDK_NO_MESSAGE_AVAILABLE(20041, "sdk no message available"),
    SDK_NO_MESSAGE(20042, "sdk no message"),
    SDK_NO_PROTOCOL_OPTION(20043, "sdk no protocol option"),
    SDK_NO_SPACE_ON_DEVICE(20044, "sdk no space on device"),
    SDK_NO_STREAM_RESOURCES(20045, "sdk no stream resources"),
    SDK_NO_SUCH_DEVICE_OR_ADDRESS(20046, "sdk no such device or address"),
    SDK_NO_SUCH_DEVICE(20047, "sdk no such device"),
    SDK_NO_SUCH_FILE_OR_DIRECTORY(20048, "sdk no such file or directory"),
    SDK_NO_SUCH_PROCESS(20049, "sdk no such process"),
    SDK_NOT_A_DIRECTORY(20050, "sdk not a directory"),
    SDK_NOT_A_SOCKET(20051, "sdk not a socket"),
    SDK_NOT_A_STREAM(20052, "sdk not a stream"),
    SDK_NOT_CONNECTED(20053, "sdk not connected"),
    SDK_NOT_ENOUGH_MEMORY(20054, "sdk not enough memory"),
    SDK_NOT_SUPPORTED(20055, "sdk not supported"),
    SDK_OPERATION_CANCELED(20056, "sdk operation canceled"),
    SDK_OPERATION_IN_PROGRESS(20057, "sdk operation in progress"),
    SDK_OPERATION_NOT_PERMITTED(20058, "sdk operation not permitted"),
    SDK_OPERATION_NOT_SUPPORTED(20059, "sdk operation not supported"),
    SDK_OPERATION_WOULD_BLOCK(20060, "sdk operation would block"),
    SDK_OWNER_DEAD(20061, "sdk owner dead"),
    SDK_PERMISSION_DENIED(20062, "sdk permission denied"),
    SDK_PROTOCOL_ERROR(20063, "sdk protocol error"),
    SDK_PROTOCOL_NOT_SUPPORTED(20064, "sdk protocol not supported"),
    SDK_READ_ONLY_FILE_SYSTEM(20065, "sdk read only file system"),
    SDK_RESOURCE_DEADLOCK_WOULD_OCCUR(20066, "sdk resource deadlock would occur"),
    SDK_RESOURCE_UNAVAILABLE_TRY_AGAIN(20067, "sdk resource unavailable try again"),
    SDK_RESULT_OUT_OF_RANGE(20068, "sdk result out of range"),
    SDK_STATE_NOT_RECOVERABLE(20069, "sdk state not recoverable"),
    SDK_STREAM_TIMEOUT(20070, "sdk stream timeout"),
    SDK_TEXT_FILE_BUSY(20071, "sdk text file busy"),
    SDK_TIMED_OUT(20072, "sdk timed out"),
    SDK_TOO_MANY_FILES_OPEN_IN_SYSTEM(20073, "sdk too many files open in system"),
    SDK_TOO_MANY_FILES_OPEN(20074, "sdk too many files open"),
    SDK_TOO_MANY_LINKS(20075, "sdk too many links"),
    SDK_TOO_MANY_SYMBOLIC_LINK_LEVELS(20076, "sdk too many symbolic link levels"),
    SDK_VALUE_TOO_LARGE(20077, "sdk value too large"),
    SDK_WRONG_PROTOCOL_TYPE(20078, "sdk wrong protocol type"),
    SDK_INVALID_PARAMETER(30000, "sdk parameter is invalid"),
    SDK_INVALID_PRIVATE_KEY(30001, "sdk invalid private key"),
    SDK_SIGN_TOOL_VERIFY_ERROR(30002, "sdk sign tool verify error"),
    SDK_UNSUPPORT_ENCODING_FAILED(30003, "sdk unsupport encoding error"),
    SDK_GET_FILE_INPUT_STREAM_FAILED(30004, "sdk get file input stream failed"),
    SDK_FIND_THREAD_FAILED(30005, "sdk find thread failed"),
    SDK_BYTES_OPERATE_FAILED(30006, "sdk bytes operate failed"),
    SDK_CONVERT_PUBLIC_KEY_FAILED(30007, "sdk convert public key failed"),
    SDK_MESSAGE_ENCODING_FAILED(30008, "sdk message encoding failed"),
    SDK_READ_CONFIG_FAILED(30009, "sdk read client config failed"),
    SDK_INIT_FAILED(30010, "sdk startup failed"),
    SDK_CONNECT_NETWORK_FAILED(30011, "sdk connect to network failed"),
    SDK_DECODE_ERROR(30012, "sdk decode error"),
    SDK_UNSUPPORT_MESSAGE_TYPE_ERROR(30013, "sdk unsupport message type error"),
    SDK_HAND_SHAKE_ERROR(30014, "did not handshake"),
    SDK_INIT_SSL_CONTEXT_FAILED(30015, "startup ssl context failed"),
    SDK_HAND_SHAKING(30016, "sdk is handshaking"),
    SDK_INVALID_PUBLIC_KEY(30017, "sdk invalid public key"),
    SDK_MESSAGE_REACHED_MAX_QUEUE_SIZE(30018, "message is reached max queue size"),
    TEE_CONFIDENTIAL_TX_DECRYPTION_FAILURE(60001, "tee confidential tx decryption failure"),
    TEE_NESTED_CONFIDENTIAL_TX(60002, "tee nested confidential tx"),
    TEE_UNEXPECPTED_PLAIN_TX(60003, "tee unexpecpted plain tx"),
    TEE_NATIVE_CONTRACT_NOT_SUPPORTED(60004, "tee native contract not supported"),
    TEE_CONFIDENTIAL_TX_DESERIALIZATION_FAILURE(60005, "tee confidential tx deserialization failure"),
    TEE_CONFIDENTIAL_STATE_DESERIALIZATION_FAILURE(60006, "tee confidential state deserialization failure"),
    TEE_ILLEGAL_ACCESSING_CONFIDENTIAL_STORAGE(60007, "tee illegal accessing confidential storage"),
    TEE_TX_TYPE_NOT_SUPPORTED(60008, "tee tx type not supported"),
    TEE_CONFIDENTIAL_TX_ENCRYPT_LOG_FAILURE(60009, "tee confidential tx encrypt log failure"),
    TEE_ACCESS_CONFIDENTIAL_CODE_DENIED(60010, "tee access confidential code denied"),
    TEE_HASH_TIMESTAMP_NOT_MATCH(60011, "tee hash timestamp not match"),
    TEE_RECEIPT_OVERFLOW(60012, "tee receipt overflow"),
    TEE_INTERNAL_ERROR(60013, "tee internal error"),
    TEE_CODE_ENCRYPTION_FAILURE(60014, "tee code encryption failure"),
    TEE_CODE_DECRYPTION_FAILURE(60015, "tee code decryption failure"),
    TEE_STORAGE_ENCRYPTION_FAILURE(60016, "tee storage encryption failure"),
    TEE_STORAGE_DECRYPTION_FAILURE(60017, "tee storage decryption failure"),
    TEE_STATE_UNMARSHAL_FAILURE(60018, "tee state unmarshal failure"),
    TEE_STATE_MARSHAL_FAILURE(60019, "tee state marshal failure"),
    TEE_PAYLOAD_DECRYPTION_FAILURE(60020, "tee payload decryption failure"),
    TEE_PAYLOAD_ENCRYPTION_FAILURE(60021, "tee payload encryption failure"),
    TEE_EXEC_PLAIN_CONTRACT_NOT_ALLOWED(60022, "tee exec plain contract not allowed"),
    TEE_UPDATE_PLAIN_CONTRACT_NOT_ALLOWED(60023, "tee update plain contract not allowed"),
    TEE_LOCAL_CONFIDENTIAL_QUERY_TYPE_NOT_FOUND(60024, "tee local confidential query type not found"),
    TEE_LOCAL_CONFIDENTIAL_QUERY_HASH_NOT_FOUND(60025, "tee local confidential query hash not found"),
    TEE_LOCAL_CONFIDENTIAL_QUERY_NOT_PERMITTED(60026, "tee local confidential query not permitted"),
    TEE_CONFIDENTIAL_RECEIPT_DECRYPTION_FAILURE(60027, "tee confidential receipt decryption failure"),
    TEE_STATE_OBJECT_INIT_FAILURE(60028, "tee state object init failure"),
    CRYPTO_GENERIC_ERROR(70000, "crypto generic error"),
    CRYPTO_INVALID_PROVIDER(70001, "crypto invalid provider"),
    CRYPTO_INVALID_KEYTYPE(70002, "crypto invalid keytype"),
    CRYPTO_INVALID_ALGOID(70003, "crypto invalid algoid"),
    CRYPTO_INVALID_PUBKEY(70004, "crypto invalid pubkey"),
    CRYPTO_INVALID_PRIVKEY(70005, "crypto invalid privkey"),
    CRYPTO_INVALID_MESSAGE(70006, "crypto invalid message"),
    CRYPTO_INVALID_PLAINTEXT(70007, "crypto invalid plaintext"),
    CRYPTO_INVALID_CIPHERTEXT(70008, "crypto invalid ciphertext"),
    CRYPTO_INVALID_SIGNATURE(70009, "crypto invalid signature"),
    CRYPTO_INVALID_SYMMETRICKEY(70010, "crypto invalid symmetrickey"),
    CRYPTO_INVALID_FILEPATH(70011, "crypto invalid filepath"),
    CRYPTO_INVALID_KEYFILE(70012, "crypto invalid keyfile"),
    CRYPTO_INVALID_X509(70013, "crypto invalid x509"),
    CRYPTO_ALGO_NOT_INIT(70101, "crypto algo not init"),
    CRYPTO_PROVIDER_ERROR(70102, "crypto provider error");

    private int value;
    private String desc;

    private ErrorCode(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static IErrorCode valueOf(int value) {
        return ErrorCode.forNumber(value);
    }

    public static IErrorCode forNumber(final int value) {
        for (ErrorCode e : ErrorCode.values()) {
            if (e.getErrorCode() != value) continue;
            return e;
        }
        return new IErrorCode(){

            @Override
            public int getErrorCode() {
                return value;
            }

            @Override
            public String getErrorDesc() {
                return "My_CHAIN_ERROR_CODE";
            }

            @Override
            public boolean isSuccess() {
                return false;
            }

            @Override
            public String toString() {
                return "ErrorCode{value=" + value + ", desc='My_CHAIN_ERROR_CODE" + '\'' + '}';
            }
        };
    }

    public String getDesc() {
        return this.desc;
    }

    @Override
    public int getErrorCode() {
        return this.value;
    }

    @Override
    public String getErrorDesc() {
        return String.valueOf(this.desc);
    }

    @Override
    public boolean isSuccess() {
        return this == SUCCESS;
    }

    @Override
    public String toString() {
        return "ErrorCode{value=" + this.value + ", desc='" + this.desc + '\'' + '}';
    }
}

