/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.admin;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import com.alipay.mychain.sdk.crypto.hash.HashTypeEnum;
import com.alipay.mychain.sdk.crypto.signer.SignerBase;
import com.alipay.mychain.sdk.domain.account.Identity;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.utils.ByteUtils;
import com.google.common.base.Strings;
import org.apache.commons.lang3.ArrayUtils;

public class DumpDbRequest
extends Request {
    private DumpDBType dumpType = DumpDBType.ALL;
    private String dumpPath;
    private Identity from;
    private byte[] signature;

    public DumpDbRequest() {
        super(MessageType.MSG_TYPE_ADMIN_REQ_DUMP_DB);
    }

    public DumpDbRequest(DumpDBType dumpType, String dumpPath, Identity from) {
        super(MessageType.MSG_TYPE_ADMIN_REQ_DUMP_DB);
        this.dumpType = dumpType;
        this.dumpPath = dumpPath;
        this.from = from;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && !this.from.hexStrValue().equalsIgnoreCase(Identity.ZERO.hexStrValue()) && this.dumpType != null && (this.dumpType.equals((Object)DumpDBType.ALL) || this.dumpType.equals((Object)DumpDBType.SPV)) && !Strings.isNullOrEmpty((String)this.dumpPath) && ArrayUtils.isNotEmpty((byte[])this.signature);
    }

    public boolean sign(SignerBase signer) {
        try {
            this.signature = signer.sign(this.hash().getValue());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Hash hash() {
        byte[] dumpTypeBytes = Rlp.encodeInt(this.dumpType.getCode());
        byte[] dumpPathBytes = Rlp.encodeString(this.dumpPath);
        byte[] fromBytes = Rlp.encodeElement(this.from.getValue());
        byte[] bytes = Rlp.encodeList(super.toRlp(), dumpTypeBytes, dumpPathBytes, fromBytes);
        return new Hash(HashFactory.getHash(HashTypeEnum.SHA256).hash(bytes));
    }

    @Override
    public byte[] toRlp() {
        byte[] dumpTypeBytes = Rlp.encodeInt(this.dumpType.getCode());
        byte[] dumpPathBytes = Rlp.encodeString(this.dumpPath);
        byte[] fromBytes = Rlp.encodeElement(this.from.getValue());
        byte[] signatureBytes = Rlp.encodeElement(this.signature);
        return Rlp.encodeList(super.toRlp(), dumpTypeBytes, dumpPathBytes, fromBytes, signatureBytes);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        this.dumpType = DumpDBType.getDumpDBTypeByCode(ByteUtils.byteArrayToInt(((RlpElement)list.get(1)).getRlpData()));
        this.dumpPath = ByteUtils.byteArrayToString(((RlpElement)list.get(2)).getRlpData());
        this.from = new Identity(((RlpElement)list.get(3)).getRlpData());
        this.signature = ((RlpElement)list.get(4)).getRlpData();
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        jsonObject.put("dump_type", (Object)this.dumpType.getCode());
        jsonObject.put("dump_path", (Object)this.dumpPath);
        jsonObject.put("from", (Object)ByteUtils.toHexString(this.from.getValue()));
        jsonObject.put("signature", (Object)ByteUtils.toHexString(this.signature));
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.dumpType = DumpDBType.getDumpDBTypeByCode(jsonObject.getIntValue("dump_type"));
        this.dumpPath = jsonObject.getString("dump_path");
        this.from = new Identity(jsonObject.getString("from"));
        this.signature = ByteUtils.hexStringToBytes(jsonObject.getString("signature"));
    }

    public DumpDBType getDumpType() {
        return this.dumpType;
    }

    public void setDumpType(DumpDBType dumpType) {
        this.dumpType = dumpType;
    }

    public String getDumpPath() {
        return this.dumpPath;
    }

    public void setDumpPath(String dumpPath) {
        this.dumpPath = dumpPath;
    }

    public Identity getFrom() {
        return this.from;
    }

    public void setFrom(Identity from) {
        this.from = from;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public static enum DumpDBType {
        ALL(0),
        SPV(1);

        private final int code;

        private DumpDBType(int code) {
            this.code = code;
        }

        public static DumpDBType getDumpDBTypeByCode(int code) {
            for (DumpDBType type : DumpDBType.values()) {
                if (type.getCode() != code) continue;
                return type;
            }
            return null;
        }

        public int getCode() {
            return this.code;
        }
    }
}

