/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.message.transaction;

import com.alibaba.fastjson.JSONObject;
import com.alipay.mychain.sdk.common.Contants;
import com.alipay.mychain.sdk.domain.transaction.Extension;
import com.alipay.mychain.sdk.domain.transaction.Transaction;
import com.alipay.mychain.sdk.message.MessageType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.rlp.Rlp;
import com.alipay.mychain.sdk.rlp.RlpElement;
import com.alipay.mychain.sdk.rlp.RlpList;
import com.alipay.mychain.sdk.type.BaseFixedSizeByteArray;
import com.alipay.mychain.sdk.type.BaseFixedSizeUnsignedInteger;
import com.alipay.mychain.sdk.utils.ByteUtils;
import java.math.BigInteger;
import java.util.List;

public abstract class AbstractTransactionRequest
extends Request {
    private Transaction transaction = new Transaction();
    private BigInteger blockNumber;
    private Boolean isLocalTransaction = false;

    public AbstractTransactionRequest(MessageType type) {
        super(type);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public void setBlockNumber(BigInteger blockNumber) {
        this.blockNumber = blockNumber;
    }

    public BigInteger getLocalBlockNumber() {
        return this.blockNumber;
    }

    public Boolean getLocalTransaction() {
        return this.isLocalTransaction;
    }

    public void setLocalTransaction() {
        this.isLocalTransaction = true;
    }

    @Override
    public boolean isValid() {
        return super.isValid();
    }

    public void complete() {
        this.transaction.setGroupId(this.groupId);
        this.transaction.calcHash();
    }

    public void setTxTimeNonce(long ts, BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger nonce, boolean force) {
        if (force) {
            this.transaction.setTimestamp(ts);
            this.transaction.setNonce(nonce);
            return;
        }
        if (this.transaction.getTimestamp() == 0L) {
            this.transaction.setTimestamp(ts);
        }
        if (this.transaction.getNonce() == BaseFixedSizeUnsignedInteger.Fixed64BitUnsignedInteger.ZERO) {
            this.transaction.setNonce(nonce);
        }
    }

    public void setTxPeriod(long period) {
        this.transaction.setPeriod(period);
    }

    public void setTxGas(long gas) {
        this.transaction.setGas(gas);
    }

    public void setTxExtensions(List<Extension> extensions) {
        this.transaction.setExtensions(extensions);
    }

    public void setLocal() {
        this.setLocal(Contants.LATEST_BLOCK_NUMBER);
    }

    public boolean isLocal() {
        return this.isLocalTransaction;
    }

    public void setLocal(BigInteger blockNumber) {
        this.setLocalTransaction();
        this.setBlockNumber(blockNumber);
        this.setMessageType(MessageType.MSG_TYPE_TX_REQ_LOCAL);
    }

    @Override
    public byte[] toRlp() {
        byte[] transactionData = this.transaction.toRlp();
        if (this.isLocal()) {
            byte[] blockNum = Rlp.encodeBigInteger(this.blockNumber);
            return Rlp.encodeList(super.toRlp(), blockNum, transactionData);
        }
        return Rlp.encodeList(super.toRlp(), transactionData);
    }

    @Override
    public void fromRlp(RlpList list) {
        super.fromRlp((RlpList)list.get(0));
        if (this.getMessageType() == MessageType.MSG_TYPE_TX_REQ_LOCAL) {
            this.blockNumber = ByteUtils.byteArrayToBigInteger(((RlpElement)list.get(1)).getRlpData());
            this.setLocal(this.blockNumber);
            this.transaction.fromRlp((RlpList)list.get(2));
            return;
        }
        this.transaction.fromRlp((RlpList)list.get(1));
    }

    @Override
    public void toJson(JSONObject jsonObject) {
        super.toJson(jsonObject);
        JSONObject object = new JSONObject();
        this.transaction.toJson(object);
        jsonObject.put("transaction", (Object)object);
        if (this.isLocal()) {
            jsonObject.put("block_number", (Object)this.blockNumber);
        }
    }

    @Override
    public void fromJson(JSONObject jsonObject) {
        super.fromJson(jsonObject);
        this.transaction.fromJson(jsonObject.getJSONObject("transaction"));
        if (this.getMessageType() == MessageType.MSG_TYPE_TX_REQ_LOCAL) {
            this.blockNumber = jsonObject.getBigInteger("block_number");
            this.setLocal(this.blockNumber);
        }
    }

    @Override
    public void setGroupId(BaseFixedSizeByteArray.Fixed20ByteArray groupId) {
        this.transaction.setGroupId(groupId);
        super.setGroupId(groupId);
    }
}

