/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network;

import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.network.PacketHead;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class MessageDecoder
extends ByteToMessageDecoder {
    private ILogger logger;

    public MessageDecoder(ILogger logger) {
        this.logger = logger;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) {
        try {
            int bufferLength = buffer.readableBytes();
            this.logger.debug("decode, bufferLength {}", (Object)bufferLength);
            if (bufferLength < 16) {
                return;
            }
            byte[] headBytes = new byte[16];
            buffer.getBytes(buffer.readerIndex(), headBytes);
            PacketHead head = PacketHead.fromBytes(headBytes);
            if (!head.verify() || head.getTotalLen() - 16 > buffer.readableBytes()) {
                return;
            }
            int bodyLength = head.getTotalLen() - 16;
            if (head.getTotalLen() > bufferLength) {
                return;
            }
            buffer.skipBytes(16);
            byte[] body = new byte[bodyLength];
            buffer.readBytes(body);
            out.add(body);
            for (int i = 0; i < out.size(); ++i) {
                ctx.fireChannelRead(out.get(i));
                out.remove(i);
            }
        }
        catch (Throwable e) {
            this.logger.error("decode caught exception: cause{}\n{}", (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e.getCause()));
        }
    }
}

