/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.network;

import com.alipay.mychain.sdk.api.callback.IConnectionCallback;
import com.alipay.mychain.sdk.api.env.ISslOption;
import com.alipay.mychain.sdk.api.env.NetworkOption;
import com.alipay.mychain.sdk.api.logging.ILogger;
import com.alipay.mychain.sdk.codec.ICodec;
import com.alipay.mychain.sdk.common.NetworkType;
import com.alipay.mychain.sdk.message.Request;
import com.alipay.mychain.sdk.message.Response;
import com.alipay.mychain.sdk.message.network.ClientHandshakeRequest;
import com.alipay.mychain.sdk.message.network.ClientHandshakeResponse;
import com.alipay.mychain.sdk.message.query.QueryNodeTimestampRequest;
import com.alipay.mychain.sdk.message.query.QueryNodeTimestampResponse;
import com.alipay.mychain.sdk.network.ChannelStatus;
import com.alipay.mychain.sdk.network.IConnection;
import com.alipay.mychain.sdk.network.IHandshakeCallback;
import com.alipay.mychain.sdk.network.MessageProcessor;
import com.alipay.mychain.sdk.network.NetworkEventHandler;
import com.alipay.mychain.sdk.network.SystemTimestamp;
import com.alipay.mychain.sdk.network.netty.BaseChannel;
import com.alipay.mychain.sdk.network.netty.HttpChannel;
import com.alipay.mychain.sdk.network.netty.TcpChannel;
import com.alipay.mychain.sdk.utils.ExecutorUtils;
import com.alipay.mychain.sdk.utils.SocketAddressUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class NetworkConnection
implements IConnection {
    private static final String SENDER_WORKER = "SenderWorker";
    private NetworkOption networkOption;
    private ICodec codec;
    private MessageProcessor processor;
    private ILogger logger;
    private Long lastActiveTime;
    private List<IConnectionCallback> callbackList;
    private BaseChannel channel;
    private SystemTimestamp timestamp;
    private int connectIndex = 0;
    private volatile ChannelStatus status = ChannelStatus.DISCONNECTED;
    private Lock lock = new ReentrantLock();
    private ExecutorService senderWorker = null;
    private ClientHandshakeResponse handshakeResponse = null;
    private QueryNodeTimestampResponse queryNodeTimestampResponse = null;

    public NetworkConnection(NetworkOption networkOption, ISslOption sslOption, ICodec codec, MessageProcessor processor, ILogger logger) {
        this.networkOption = networkOption;
        this.logger = logger;
        this.codec = codec;
        this.processor = processor;
        this.timestamp = new SystemTimestamp();
        this.lastActiveTime = System.currentTimeMillis();
        this.callbackList = new ArrayList<IConnectionCallback>();
        NetworkEventHandler netEventHandler = new NetworkEventHandler(processor);
        this.channel = networkOption.getNetworkType() == NetworkType.TLS ? new TcpChannel(logger).init(netEventHandler, this.networkOption, sslOption) : new HttpChannel(logger).init(netEventHandler, this.networkOption, sslOption);
    }

    public void start() {
        this.senderWorker = ExecutorUtils.getListeningExecutorService(1, SENDER_WORKER, (int)this.networkOption.getThreadPoolQueueSize());
        this.channel.start();
    }

    public void stop() {
        this.close();
        this.channel.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(Long connectionEndTime) {
        this.logger.debug("connect, connectionEndTime:{}", (Object)connectionEndTime);
        if (this.codec == null || this.processor == null) {
            this.logger.error("connect, codec or processor is null");
            return false;
        }
        if (this.networkOption.getSocketAddressList().isEmpty()) {
            this.logger.error("connect, network endpoints is empty");
            return false;
        }
        boolean result = false;
        try {
            this.lock.lock();
            if (this.status == ChannelStatus.CONNECTING || this.status == ChannelStatus.CONNECTED && this.channel != null && this.channel.isRunning()) {
                this.logger.debug("connect, channel is running...");
                boolean bl = true;
                return bl;
            }
            this.status = ChannelStatus.CONNECTING;
            int index = this.connectIndex;
            block4: do {
                for (int i = 0; i < this.networkOption.getSocketAddressList().size(); ++i) {
                    this.connectIndex = (index + i) % this.networkOption.getSocketAddressList().size();
                    for (int connectTimes = 0; connectTimes < this.networkOption.getRetryConnectTimes(); ++connectTimes) {
                        InetSocketAddress socketAddress = this.networkOption.getSocketAddressList().get(this.connectIndex);
                        Integer connectTimeout = this.networkOption.getConnectTimeoutMs();
                        this.logger.debug("connect, connectTimes:{}, socketAddress:{}, connectTimeout:{}", connectTimes, SocketAddressUtil.parseAddress(socketAddress), connectTimeout);
                        result = this.connect(socketAddress, connectTimeout);
                        if (!result) continue;
                        this.updateLastActiveTime();
                        this.status = ChannelStatus.CONNECTED;
                        break;
                    }
                    if (this.status == ChannelStatus.CONNECTED) continue block4;
                }
            } while (this.status != ChannelStatus.CONNECTED && connectionEndTime > System.currentTimeMillis());
            if (!result) {
                this.status = ChannelStatus.DISCONNECTED;
            }
        }
        finally {
            this.lock.unlock();
        }
        if (result) {
            this.notifyEvent();
        }
        return result;
    }

    @Override
    public boolean disConnect() {
        try {
            this.lock.lock();
            if (this.status != ChannelStatus.CONNECTED) {
                boolean bl = true;
                return bl;
            }
            this.logger.info("disConnect, update status");
            this.status = ChannelStatus.DISCONNECTED;
            ++this.connectIndex;
        }
        finally {
            this.lock.unlock();
        }
        this.notifyEvent();
        return true;
    }

    @Override
    public boolean registerEventHandler(IConnectionCallback callback) {
        if (callback == null) {
            return false;
        }
        try {
            this.lock.lock();
            this.callbackList.add(callback);
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    public Long getLastActiveTime() {
        try {
            this.lock.lock();
            Long l = this.lastActiveTime;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void updateLastActiveTime() {
        try {
            this.lock.lock();
            this.lastActiveTime = System.currentTimeMillis();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void checkAndSetStatus(ChannelStatus status) {
        if (status == ChannelStatus.DISCONNECTED && this.senderWorker != null && !this.senderWorker.isShutdown()) {
            this.logger.info("checkAndSetStatus, run disConnect.");
            this.senderWorker.submit(new Runnable(){

                @Override
                public void run() {
                    NetworkConnection.this.disConnect();
                }
            });
        }
    }

    @Override
    public void disConnectForce() {
        try {
            this.lock.lock();
            if (this.senderWorker != null && !this.senderWorker.isShutdown()) {
                this.senderWorker.submit(new Runnable(){

                    @Override
                    public void run() {
                        NetworkConnection.this.disConnect();
                    }
                });
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Long getSystemTimestamp() {
        return this.timestamp.getCurrentTimestamp();
    }

    public void setSystemTimestamp(Long ts) {
        this.timestamp.setBenchmarkTimestamp(ts);
    }

    public boolean sendRequest(final Request request, final Long connectionEndTime) {
        this.logger.info("sendRequest, message:{}", (Object)request.toString());
        if (this.senderWorker != null && !this.senderWorker.isShutdown()) {
            this.senderWorker.submit(new Runnable(){

                @Override
                public void run() {
                    NetworkConnection.this.logger.debug("sendRequest, submit request, seq:{}", (Object)request.getSequenceId());
                    boolean result = NetworkConnection.this.connect(connectionEndTime);
                    if (!result) {
                        NetworkConnection.this.logger.error("sendRequest, connect failed, seq:{}", (Object)request.getSequenceId());
                        return;
                    }
                    byte[] stream = NetworkConnection.this.codec.encode(request);
                    if (stream == null) {
                        NetworkConnection.this.logger.error("sendRequest, encode failed, seq:{}", (Object)request.getSequenceId());
                        return;
                    }
                    NetworkConnection.this.channel.sendRequest(stream);
                }
            });
        }
        return true;
    }

    private boolean connect(InetSocketAddress address, int timeout) {
        this.logger.info("connect, address:{}, timeout:{}", (Object)address, (Object)timeout);
        if (this.channel != null && this.channel.connect(address, timeout)) {
            if (NetworkType.TLS == this.networkOption.getNetworkType()) {
                return this.handshake(timeout);
            }
            return this.updateSystemTimestamp(timeout);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent() {
        try {
            this.lock.lock();
            InetSocketAddress endpoint = this.networkOption.getSocketAddressList().get(this.connectIndex % this.networkOption.getSocketAddressList().size());
            for (IConnectionCallback callback : this.callbackList) {
                if (callback == null) continue;
                if (this.status == ChannelStatus.CONNECTED) {
                    this.logger.debug("notifyEvent, network is connected.");
                    callback.onConnect(endpoint);
                    continue;
                }
                if (this.status != ChannelStatus.DISCONNECTED) continue;
                this.logger.debug("notifyEvent, network is disConnected.");
                callback.onDisConnect(endpoint);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        try {
            this.lock.lock();
            if (this.senderWorker != null && !this.senderWorker.isShutdown()) {
                this.senderWorker.shutdown();
            }
            this.callbackList.clear();
        }
        catch (Exception e) {
            this.logger.error("close worker failed. e:{}", (Object)e.getMessage());
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean updateSystemTimestamp(int timeout) {
        this.logger.info("updateSystemTimestamp, start timeout:{}", (Object)timeout);
        boolean result = false;
        final CountDownLatch latch = new CountDownLatch(1);
        this.processor.setHandshakeCallback(new IHandshakeCallback(){

            @Override
            public void onResponse(Response response) {
                if (response != null) {
                    NetworkConnection.this.setNodeTimestampResponse((QueryNodeTimestampResponse)response);
                    latch.countDown();
                }
            }
        });
        try {
            byte[] bytes = this.codec.encode(this.createQueryNodeTimestamp());
            this.channel.sendRequest(bytes);
            boolean awaitResult = latch.await(timeout, TimeUnit.MILLISECONDS);
            if (awaitResult && this.queryNodeTimestampResponse != null) {
                this.setSystemTimestamp(this.queryNodeTimestampResponse.getTimestamp());
                result = true;
            } else {
                result = false;
                this.logger.error("queryNodeTimestampResponse failed.");
            }
        }
        catch (InterruptedException e) {
            this.logger.error("queryNodeTimestampResponse failed, cause: {}\n{}", (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e.getCause()));
        }
        this.queryNodeTimestampResponse = null;
        this.logger.debug("updateSystemTimestamp, completed. result:{}", (Object)(result ? "succeed" : "failed"));
        return result;
    }

    private boolean handshake(int timeout) {
        this.logger.info("handshake, start timeout:{}", (Object)timeout);
        boolean result = false;
        final CountDownLatch latch = new CountDownLatch(1);
        this.processor.setHandshakeCallback(new IHandshakeCallback(){

            @Override
            public void onResponse(Response response) {
                if (response != null) {
                    NetworkConnection.this.setHandshakeResponse((ClientHandshakeResponse)response);
                    latch.countDown();
                }
            }
        });
        try {
            byte[] bytes = this.codec.encode(this.createHandShakeMessage());
            this.channel.sendRequest(bytes);
            boolean waitResult = latch.await(timeout, TimeUnit.MILLISECONDS);
            if (waitResult && this.handshakeResponse != null) {
                this.setSystemTimestamp(this.handshakeResponse.getTimestamp());
                result = true;
                this.logger.debug("handshake success.");
            } else {
                result = false;
                this.logger.error("handshake failed.");
            }
        }
        catch (InterruptedException e) {
            this.logger.error("handshake failed, cause: {}\n{}", (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e.getCause()));
        }
        this.handshakeResponse = null;
        this.logger.debug("handshake, completed. result:{}", (Object)(result ? "succeed" : "failed"));
        return result;
    }

    private ClientHandshakeRequest createHandShakeMessage() {
        return new ClientHandshakeRequest();
    }

    private QueryNodeTimestampRequest createQueryNodeTimestamp() {
        return new QueryNodeTimestampRequest();
    }

    private void setHandshakeResponse(ClientHandshakeResponse response) {
        this.handshakeResponse = response;
    }

    private void setNodeTimestampResponse(QueryNodeTimestampResponse response) {
        this.queryNodeTimestampResponse = response;
    }
}

