/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.trie;

import com.alipay.mychain.sdk.crypto.hash.Hash;
import com.alipay.mychain.sdk.crypto.hash.HashFactory;
import java.util.List;
import java.util.Vector;

public class MerkleTree {
    public static Hash root(Vector<Hash> hashes) {
        if (hashes.isEmpty()) {
            return new Hash();
        }
        int n = hashes.size();
        double n2 = Math.pow(2.0, Math.ceil(Math.log(n) / Math.log(2.0)));
        hashes = MerkleTree.resetVector(hashes, (int)n2);
        while (hashes.size() > 1) {
            int odd = hashes.size() & 1;
            if (odd != 0) {
                Hash hash = hashes.get(hashes.size() - 1);
                if (hash == null) {
                    hash = new Hash();
                }
                hashes.add(hash);
            }
            for (int i = 0; i < hashes.size(); i += 2) {
                byte[] tmp = new byte[64];
                System.arraycopy(hashes.get(i).getValue(), 0, tmp, 0, 32);
                System.arraycopy(hashes.get(i + 1).getValue(), 0, tmp, 32, 32);
                hashes.set(i / 2, new Hash(HashFactory.getHash().hash(tmp)));
            }
            hashes = MerkleTree.resetVector(hashes, hashes.size() / 2);
        }
        return hashes.get(0);
    }

    private static Vector<Hash> resetVector(Vector<Hash> hashes, int n) {
        if (hashes.size() >= n) {
            hashes.setSize(n);
            return hashes;
        }
        hashes.setSize(n);
        for (int i = 0; i < n; ++i) {
            if (hashes.get(i) != null) continue;
            hashes.set(i, new Hash());
        }
        return hashes;
    }

    public static boolean verify(int index, Hash txHash, Hash receiptRootHash, List<Hash> branches, int size) {
        if (index >= size) {
            return false;
        }
        double n2 = Math.ceil(Math.log(size) / Math.log(2.0));
        if ((double)branches.size() != n2) {
            return false;
        }
        Hash calRoot = txHash;
        byte[] buf = new byte[64];
        for (Hash hash : branches) {
            if ((index & 1) != 0) {
                System.arraycopy(hash.getValue(), 0, buf, 0, 32);
                System.arraycopy(calRoot.getValue(), 0, buf, 32, 32);
            } else {
                System.arraycopy(calRoot.getValue(), 0, buf, 0, 32);
                System.arraycopy(hash.getValue(), 0, buf, 32, 32);
            }
            calRoot = new Hash(HashFactory.getHash().hash(buf));
            index /= 2;
        }
        return calRoot.equals(receiptRootHash);
    }
}

