/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.sdk.vm.wasm;

import com.alipay.mychain.sdk.utils.ByteUtils;
import com.alipay.mychain.sdk.vm.abi.datatype.Type;
import com.alipay.mychain.sdk.vm.utils.Numeric;
import com.alipay.mychain.sdk.vm.wasm.DecodeNext;
import com.alipay.mychain.sdk.vm.wasm.MyWasmTypeDecoder;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public final class Leb128Utils {
    private Leb128Utils() {
    }

    public static String leb128HexString(int value) {
        ArrayList<Byte> length = new ArrayList<Byte>();
        do {
            byte b = (byte)(value & 0x7F);
            int isContinue = (value >>= 7) > 0 ? 1 : 0;
            b = (byte)(b | isContinue << 7);
            length.add(b);
        } while (value > 0);
        return Numeric.toHexStringNoPrefix(ArrayUtils.toPrimitive((Byte[])length.toArray(new Byte[length.size()])));
    }

    public static byte[] getInputHeaderLengthBytes(byte[] dataSource, DecodeNext decodeNext) {
        int i;
        if (decodeNext == null) {
            return new byte[0];
        }
        int v = 0;
        int by = 0;
        for (i = 0; i < dataSource.length; ++i) {
            char b = (char)dataSource[i];
            byte low7 = (byte)(b & 0x7F);
            v |= low7 << by;
            by = (byte)(by + 7);
            byte index8 = (byte)(b & 0x80);
            if (index8 != 0) continue;
            ++i;
            break;
        }
        byte[] headerLengthBytes = new byte[i];
        System.arraycopy(dataSource, 0, headerLengthBytes, 0, i);
        decodeNext.setHeaderLength(v);
        return headerLengthBytes;
    }

    public static <T extends Type> DecodeNext decodeLeb(String input, Class<T> type) {
        DecodeNext decodeNext;
        int singleByteLength = MyWasmTypeDecoder.getClassSingleByteLength(type, input);
        byte[] dataSource = ByteUtils.hexStringToBytes(input);
        byte[] headerLengthBytes = Leb128Utils.getInputHeaderLengthBytes(dataSource, decodeNext = new DecodeNext());
        if (ArrayUtils.isEmpty((byte[])headerLengthBytes)) {
            return decodeNext;
        }
        int dataLength = decodeNext.getHeaderLength() * singleByteLength;
        byte[] data = new byte[dataLength];
        System.arraycopy(dataSource, headerLengthBytes.length, data, 0, dataLength);
        String cut = ByteUtils.toHexString(headerLengthBytes) + ByteUtils.toHexString(data);
        decodeNext.setRemainData(ByteUtils.toHexString(data));
        decodeNext.setCutString(cut);
        return decodeNext;
    }
}

