/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto.ecdsa;

import com.alipay.mychain.zoro.crypto.ecdsa.AbstractKeyPair;
import com.alipay.mychain.zoro.crypto.ecdsa.ECDSASignature;
import com.alipay.mychain.zoro.crypto.ecdsa.NumericUtils;
import com.alipay.mychain.zoro.crypto.ecdsa.SignatureData;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;

public class ECSignUtils {
    private static final X9ECParameters CURVE_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    public static final ECDomainParameters CURVE = new ECDomainParameters(CURVE_PARAMS.getCurve(), CURVE_PARAMS.getG(), CURVE_PARAMS.getN(), CURVE_PARAMS.getH());
    static final BigInteger HALF_CURVE_ORDER = CURVE_PARAMS.getN().shiftRight(1);

    public static SignatureData signMessage(byte[] message, AbstractKeyPair keyPair) {
        BigInteger publicKey = keyPair.getPublicKey();
        ECDSASignature sig = (ECDSASignature)keyPair.sign(message);
        int recId = -1;
        int length = 4;
        for (int i = 0; i < length; ++i) {
            BigInteger k = ECSignUtils.recoverFromSignature(i, sig, message);
            if (k == null || !k.equals(publicKey)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        int headerByte = recId;
        byte v = (byte)headerByte;
        byte[] r = NumericUtils.toBytesPadded(sig.r, 32);
        byte[] s = NumericUtils.toBytesPadded(sig.s, 32);
        return new SignatureData(v, r, s);
    }

    public static BigInteger recoverFromSignature(int recId, ECDSASignature sig, byte[] message) {
        BigInteger prime;
        BigInteger n = CURVE.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = sig.r.add(i.multiply(n));
        if (x.compareTo(prime = SecP256K1Curve.q) >= 0) {
            return null;
        }
        ECPoint r = ECSignUtils.decompressKey(x, (recId & 1) == 1);
        if (!r.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, message);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = sig.r.modInverse(n);
        BigInteger srInv = rInv.multiply(sig.s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)CURVE.getG(), (BigInteger)eInvrInv, (ECPoint)r, (BigInteger)srInv);
        byte[] qBytes = q.getEncoded(false);
        return new BigInteger(1, Arrays.copyOfRange(qBytes, 1, qBytes.length));
    }

    private static ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(CURVE.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return CURVE.getCurve().decodePoint(compEnc);
    }

    public static BigInteger signedMessageToKey(byte[] message, SignatureData signatureData) throws SignatureException {
        int headerLength = 3;
        byte[] r = signatureData.getR();
        byte[] s = signatureData.getS();
        int header = signatureData.getV() & 0xFF;
        if (header > headerLength) {
            throw new SignatureException("Header byte out of range: " + header);
        }
        int recId = header;
        ECDSASignature sig = new ECDSASignature(new BigInteger(1, signatureData.getR()), new BigInteger(1, signatureData.getS()));
        BigInteger key = ECSignUtils.recoverFromSignature(recId, sig, message);
        if (key == null) {
            throw new SignatureException("Could not recover public key from signature");
        }
        return key;
    }

    public static BigInteger publicKeyFromPrivate(BigInteger privKey) {
        ECPoint point = ECSignUtils.publicPointFromPrivate(privKey);
        byte[] encoded = point.getEncoded(false);
        return new BigInteger(1, Arrays.copyOfRange(encoded, 1, encoded.length));
    }

    public static PublicKey publicKeyFromPrivateKey(BigInteger privKey) throws Exception {
        ECPoint point = ECSignUtils.publicPointFromPrivate(privKey);
        String name = "secp256k1";
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
        ECNamedCurveParameterSpec parameterSpec = ECNamedCurveTable.getParameterSpec((String)name);
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(point, (ECParameterSpec)parameterSpec);
        ECPublicKey publicKey = (ECPublicKey)keyFactory.generatePublic((KeySpec)ecPublicKeySpec);
        return publicKey;
    }

    private static ECPoint publicPointFromPrivate(BigInteger privKey) {
        if (privKey.bitLength() > CURVE.getN().bitLength()) {
            privKey = privKey.mod(CURVE.getN());
        }
        return new FixedPointCombMultiplier().multiply(CURVE.getG(), privKey);
    }
}

