/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.mychain.zoro.crypto.keymanagement;

import com.alipay.mychain.zoro.crypto.AlgorithmService;
import com.alipay.mychain.zoro.crypto.CryptoException;
import com.alipay.mychain.zoro.crypto.keymanagement.KeyManagementRaw;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.util.encoders.Base64;

public class KeyManagement {
    private static final Logger logger = Logger.getLogger(KeyManagement.class.getName());
    private static final Object LOCK_1 = new Object();
    private static Map<String, byte[]> keysAfterWrap = new ConcurrentHashMap<String, byte[]>();
    private static volatile SecretKey keyWrapKey;
    private static final ThreadLocal<Cipher> UNWRAPCIPHER;

    private static SecretKey generateKEK() throws NoSuchAlgorithmException {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            return keyGenerator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("The aes key wrap func, no such alg.", e);
        }
    }

    private static String hash2MapKey(byte[] keyname, byte[] password) {
        byte[] tmpbuf = new byte[keyname.length + password.length];
        System.arraycopy(keyname, 0, tmpbuf, 0, keyname.length);
        System.arraycopy(password, 0, tmpbuf, keyname.length, password.length);
        byte[] hm = AlgorithmService.sha256(tmpbuf);
        Arrays.fill(tmpbuf, (byte)0);
        return Base64.toBase64String((byte[])hm);
    }

    private static void cacheKey(String keyIdx, PrivateKey priKey) throws CryptoException {
        try {
            Cipher keyWrapCipher = Cipher.getInstance("AES");
            keyWrapCipher.init(3, keyWrapKey);
            keysAfterWrap.put(keyIdx, keyWrapCipher.wrap(priKey));
        }
        catch (Exception e) {
            throw new CryptoException("key wrap exception.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshKEKsandReload() {
        Object object = LOCK_1;
        synchronized (object) {
            keyWrapKey = null;
            keysAfterWrap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RSAPrivateKey getRsaPrivateKey(byte[] keyname, byte[] password) throws CryptoException {
        if (keyname == null) {
            throw new CryptoException("get rsa private key exception. keyname is null.");
        }
        if (password == null) {
            throw new CryptoException("get rsa private key exception. password is null.");
        }
        try {
            String keyIdx = KeyManagement.hash2MapKey(keyname, password);
            Object object = LOCK_1;
            synchronized (object) {
                if (keyWrapKey == null) {
                    keyWrapKey = KeyManagement.generateKEK();
                    keysAfterWrap.clear();
                    RSAPrivateKey rsaPriKey = KeyManagementRaw.getInstance().getRsaPrivateKey(keyname, password);
                    KeyManagement.cacheKey(keyIdx, rsaPriKey);
                    return rsaPriKey;
                }
                if (!keysAfterWrap.containsKey(keyIdx)) {
                    RSAPrivateKey rsaPriKey = KeyManagementRaw.getInstance().getRsaPrivateKey(keyname, password);
                    KeyManagement.cacheKey(keyIdx, rsaPriKey);
                    return rsaPriKey;
                }
                Cipher keyWrapCipher = UNWRAPCIPHER.get();
                keyWrapCipher.init(4, keyWrapKey);
                return (RSAPrivateKey)keyWrapCipher.unwrap(keysAfterWrap.get(keyIdx), "RSA", 2);
            }
        }
        catch (Exception e) {
            UNWRAPCIPHER.remove();
            throw new CryptoException("get rsa private key exception.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ECPrivateKey getEcdsaPrivateKey(byte[] keyname, byte[] password) throws CryptoException {
        if (keyname == null) {
            throw new CryptoException("get ec private key exception. keyname is null.");
        }
        if (password == null) {
            throw new CryptoException("get ec private key exception. password is null.");
        }
        try {
            String keyIdx = KeyManagement.hash2MapKey(keyname, password);
            Object object = LOCK_1;
            synchronized (object) {
                if (keyWrapKey == null) {
                    keyWrapKey = KeyManagement.generateKEK();
                    keysAfterWrap.clear();
                    ECPrivateKey ecdsaPriKey = KeyManagementRaw.getInstance().getEcdsaPrivateKey(keyname, password);
                    KeyManagement.cacheKey(keyIdx, ecdsaPriKey);
                    return ecdsaPriKey;
                }
                if (!keysAfterWrap.containsKey(keyIdx)) {
                    ECPrivateKey ecdsaPriKey = KeyManagementRaw.getInstance().getEcdsaPrivateKey(keyname, password);
                    KeyManagement.cacheKey(keyIdx, ecdsaPriKey);
                    return ecdsaPriKey;
                }
                Cipher keyWrapCipher = UNWRAPCIPHER.get();
                keyWrapCipher.init(4, keyWrapKey);
                return (ECPrivateKey)keyWrapCipher.unwrap(keysAfterWrap.get(keyIdx), "EC", 2);
            }
        }
        catch (Exception e) {
            UNWRAPCIPHER.remove();
            throw new CryptoException("get ecdsa private key exception.", e);
        }
    }

    public static RSAPublicKey getRsaPublicKey(byte[] modulus, byte[] publicExponent) throws CryptoException {
        RSAPublicKey pubKey;
        try {
            BigInteger bnN = new BigInteger(modulus);
            BigInteger bnE = new BigInteger(publicExponent);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(bnN, bnE);
            pubKey = (RSAPublicKey)keyFactory.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            throw new CryptoException("RSA 2048 get public key fail.", e);
        }
        return pubKey;
    }

    public static ECPublicKey getEcdsaPublicKey(byte[] pubkeyX, byte[] pubkeyY) throws CryptoException {
        ECPublicKey ecPublicKey;
        try {
            BigInteger bnPubKeyX = new BigInteger(pubkeyX);
            BigInteger bnPubKeyY = new BigInteger(pubkeyY);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            ECPoint ecPointPubKey = new ECPoint(bnPubKeyX, bnPubKeyY);
            ECParameterSpec ecParameterSpec = KeyManagement.getECParameter();
            ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(ecPointPubKey, ecParameterSpec);
            ecPublicKey = (ECPublicKey)keyFactory.generatePublic(ecPublicKeySpec);
        }
        catch (Exception e) {
            throw new CryptoException("ECDSA get public key fail.", e);
        }
        return ecPublicKey;
    }

    public static ECParameterSpec getECParameter() throws CryptoException {
        ECParameterSpec ecParameterSpec;
        BigInteger bnP = new BigInteger("+FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFC2F", 16);
        BigInteger bnA = new BigInteger("+0000000000000000000000000000000000000000000000000000000000000000", 16);
        BigInteger bnB = new BigInteger("+0000000000000000000000000000000000000000000000000000000000000007", 16);
        BigInteger bnGx = new BigInteger("+79BE667EF9DCBBAC55A06295CE870B07029BFCDB2DCE28D959F2815B16F81798", 16);
        BigInteger bnGy = new BigInteger("+483ADA7726A3C4655DA4FBFC0E1108A8FD17B448A68554199C47D08FFB10D4B8", 16);
        BigInteger bnN = new BigInteger("+FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEBAAEDCE6AF48A03BBFD25E8CD0364141", 16);
        try {
            ECFieldFp field = new ECFieldFp(bnP);
            EllipticCurve curve = new EllipticCurve(field, bnA, bnB);
            ECPoint ecPointG = new ECPoint(bnGx, bnGy);
            ecParameterSpec = new ECParameterSpec(curve, ecPointG, bnN, 1);
        }
        catch (Exception e) {
            throw new CryptoException("ECDSA get ECParameter fail.", e);
        }
        return ecParameterSpec;
    }

    public static boolean checkECParameter(ECParameterSpec ecParameterSpec) throws CryptoException {
        ECParameterSpec ecParameterSpec2;
        ECParameterSpec ecParameterSpec1;
        try {
            ecParameterSpec1 = KeyManagement.getECParameter();
            ecParameterSpec2 = ecParameterSpec;
        }
        catch (Exception e) {
            throw new CryptoException("ECDSA Sign Check Key Fail. GetParams fail.", e);
        }
        if (ecParameterSpec2 == null || ecParameterSpec1 == null) {
            throw new CryptoException("ECDSA Sign Check Key Fail. ECParameterSpec is null.");
        }
        if (!ecParameterSpec1.getCurve().equals(ecParameterSpec2.getCurve())) {
            return false;
        }
        if (ecParameterSpec1.getCofactor() != ecParameterSpec2.getCofactor()) {
            return false;
        }
        if (!ecParameterSpec1.getOrder().equals(ecParameterSpec2.getOrder())) {
            return false;
        }
        return ecParameterSpec1.getGenerator().equals(ecParameterSpec2.getGenerator());
    }

    static {
        UNWRAPCIPHER = new ThreadLocal<Cipher>(){

            @Override
            protected Cipher initialValue() {
                try {
                    return Cipher.getInstance("AES");
                }
                catch (NoSuchAlgorithmException e) {
                    logger.log(Level.SEVERE, "AES encryption algorithm NOT Found.", e);
                }
                catch (NoSuchPaddingException e) {
                    logger.log(Level.SEVERE, "AES Padding NOT Found.", e);
                }
                return null;
            }
        };
    }
}

