/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson15.parser.deserializer;

import com.alibaba.fastjson15.parser.DefaultJSONParser;
import com.alibaba.fastjson15.parser.JSONLexer;
import com.alibaba.fastjson15.parser.ParserConfig;
import com.alibaba.fastjson15.parser.deserializer.FieldDeserializer;
import com.alibaba.fastjson15.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson15.util.FieldInfo;
import java.lang.reflect.Type;
import java.util.Map;

public class StringFieldDeserializer
extends FieldDeserializer {
    private final ObjectDeserializer fieldValueDeserilizer;

    public StringFieldDeserializer(ParserConfig config, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo);
        this.fieldValueDeserilizer = config.getDeserializer(fieldInfo);
    }

    @Override
    public void parseField(DefaultJSONParser parser, Object object, Type objectType, Map<String, Object> fieldValues) {
        String value;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 4) {
            value = lexer.stringVal();
            lexer.nextToken(16);
        } else {
            Object obj = parser.parse();
            value = obj == null ? null : obj.toString();
        }
        if (object == null) {
            fieldValues.put(this.fieldInfo.getName(), value);
        } else {
            this.setValue(object, value);
        }
    }

    @Override
    public int getFastMatchToken() {
        return this.fieldValueDeserilizer.getFastMatchToken();
    }
}

