/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson15.serializer;

import com.alibaba.fastjson15.serializer.JSONSerializer;
import com.alibaba.fastjson15.serializer.ObjectSerializer;
import com.alibaba.fastjson15.serializer.SerializeWriter;
import com.alibaba.fastjson15.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Type;

public class IntArraySerializer
implements ObjectSerializer {
    public static IntArraySerializer instance = new IntArraySerializer();

    @Override
    public final void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        int[] array = (int[])object;
        out.write('[');
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                out.write(',');
            }
            out.writeInt(array[i]);
        }
        out.write(']');
    }
}

