/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk;

import com.alibaba.fastjson15.JSON;
import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.AESUtils;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.RandomUtils;
import com.upay.sdk.exception.RequestException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.reader.CertificateReader;
import com.upay.sdk.reader.PathCertificateReader;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CipherWrapper {
    static final Logger LOGGER = LoggerFactory.getLogger(CipherWrapper.class);
    private static final String DATA = "data";
    private static final String ENCRYPT_KEY = "encryptKey";
    private static final String MERCHANT_ID = "merchantId";
    private static final String REQUEST_ID = "requestId";
    private static final String PARTNER_ID = "partnerId";
    private static final String HMAC = "hmac";
    private static CertificateReader certificateReader = new PathCertificateReader();

    public static JSONObject encryptWrap(String merchantId, String jsonObject) throws UnknownException {
        return CipherWrapper.encryptWrap(merchantId, JSONObject.parseObject(jsonObject));
    }

    public static JSONObject encryptWrap(String merchantId, JSONObject jsonObject) throws UnknownException {
        return CipherWrapper.encryptWrap(merchantId, null, jsonObject);
    }

    public static JSONObject encryptWrap(String merchantId, String partnerId, JSONObject jsonObject) throws UnknownException {
        String encryptKey;
        String merchantAESKey = RandomUtils.generateAlphaAndDigit(16);
        String requestId = jsonObject.getString(REQUEST_ID);
        String jsonStr = jsonObject.toJSONString();
        String data = AESUtils.encryptToBase64(jsonStr, merchantAESKey);
        String publicKey = ConfigurationUtils.getPublicKey(StringUtils.isNotBlank((CharSequence)partnerId) ? partnerId : merchantId);
        if (StringUtils.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("no publicKey configuration");
        }
        try {
            encryptKey = RSAUtils.encryptByPublicKey(merchantAESKey, publicKey);
        }
        catch (Exception e) {
            JSONObject json = new JSONObject();
            json.put(Constants.STATUS, (Object)Constants.ERROR);
            json.put(Constants.ERROR_MSG, (Object)"RSA encrypt error");
            throw new RequestException(json);
        }
        JSONObject json = new JSONObject();
        json.put(DATA, (Object)data);
        json.put(ENCRYPT_KEY, (Object)encryptKey);
        json.put(MERCHANT_ID, (Object)merchantId);
        json.put(REQUEST_ID, (Object)requestId);
        if (StringUtils.isNotBlank((CharSequence)partnerId)) {
            json.put(PARTNER_ID, (Object)partnerId);
        }
        return json;
    }

    public static JSONObject decryptWrap(String jsonObject) throws UnknownException {
        return CipherWrapper.decryptWrap(JSON.parseObject(jsonObject));
    }

    public static JSONObject decryptWrap(JSONObject json) throws UnknownException {
        String AESKey;
        String partnerId;
        if (json == null) {
            return null;
        }
        String data = json.get(DATA) == null ? null : String.valueOf(json.get(DATA));
        String encryptKey = json.get(ENCRYPT_KEY) == null ? null : String.valueOf(json.get(ENCRYPT_KEY));
        String merchantId = json.get(MERCHANT_ID) == null ? null : String.valueOf(json.get(MERCHANT_ID));
        String string = partnerId = json.get(PARTNER_ID) == null ? null : String.valueOf(json.get(PARTNER_ID));
        if (data == null || encryptKey == null || merchantId == null) {
            throw new IllegalArgumentException(String.format("data:[%s],encryptKey:[%s],merchantId:[%s]", data, encryptKey, merchantId));
        }
        String publicKey = ConfigurationUtils.getPublicKey(StringUtils.isNotBlank((CharSequence)partnerId) ? partnerId : merchantId);
        if (StringUtils.isBlank((CharSequence)publicKey)) {
            throw new IllegalArgumentException("no publicKey configuration");
        }
        try {
            AESKey = RSAUtils.decryptByPublicKey(encryptKey, publicKey);
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        String realData = AESUtils.decryptFromBase64(data, AESKey);
        return StringUtils.isBlank((CharSequence)realData) ? null : JSON.parseObject(realData);
    }

    public static JSONObject bothEncryptWrap(String merchantId, JSONObject jsonObject) throws UnknownException {
        return CipherWrapper.bothEncryptWrap(merchantId, null, jsonObject);
    }

    public static JSONObject bothEncryptWrap(String merchantId, String partnerId, JSONObject jsonObject) throws UnknownException {
        String encryptKey;
        String data;
        try {
            String privateKey = CipherWrapper.getPrivateKey(partnerId, merchantId);
            jsonObject.put(HMAC, (Object)RSAUtils.sign(jsonObject.getBytes(HMAC), privateKey));
            String randomKey = RandomUtils.generateAlphaAndDigit(16);
            LOGGER.info("bothEncryptWrap jsonObject:{}", (Object)jsonObject);
            data = AESUtils.encryptToBase64(jsonObject.toJSONString(), randomKey);
            encryptKey = RSAUtils.encryptByPublicKey(randomKey, certificateReader.readPublicKey());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        JSONObject json = new JSONObject();
        json.put(DATA, (Object)data);
        json.put(ENCRYPT_KEY, (Object)encryptKey);
        json.put(MERCHANT_ID, (Object)merchantId);
        json.put(REQUEST_ID, (Object)jsonObject.getString(REQUEST_ID));
        if (StringUtils.isNotBlank((CharSequence)partnerId)) {
            json.put(PARTNER_ID, (Object)partnerId);
        }
        return json;
    }

    private static String getPrivateKey(String partnerId, String merchantId) throws Exception {
        String key = (String)StringUtils.defaultIfBlank((CharSequence)partnerId, (CharSequence)merchantId);
        String privateKey = certificateReader.readPrivateKey(key);
        return privateKey;
    }

    private static String getOldPrivateKey(String partnerId, String merchantId) throws Exception {
        String key = (String)StringUtils.defaultIfBlank((CharSequence)partnerId, (CharSequence)merchantId);
        String privateKey = certificateReader.readOldPrivateKey(key);
        return privateKey;
    }

    public static JSONObject bothDecryptWrap(JSONObject json) throws UnknownException {
        String realData;
        String realEncryptKey;
        String data;
        block9: {
            String privateKey;
            data = json.get(DATA) == null ? null : String.valueOf(json.get(DATA));
            String encryptKey = json.get(ENCRYPT_KEY) == null ? null : String.valueOf(json.get(ENCRYPT_KEY));
            String merchantId = json.get(MERCHANT_ID) == null ? null : String.valueOf(json.get(MERCHANT_ID));
            String partnerId = json.get(PARTNER_ID) == null ? null : String.valueOf(json.get(PARTNER_ID));
            LOGGER.info("bothDecryptWrap merchantId:[{}],partnerId[{}]", (Object)merchantId, (Object)partnerId);
            if (data == null || encryptKey == null || merchantId == null) {
                return null;
            }
            try {
                privateKey = CipherWrapper.getPrivateKey(partnerId, merchantId);
            }
            catch (Exception e) {
                throw new UnknownException(e);
            }
            realEncryptKey = null;
            try {
                realEncryptKey = RSAUtils.decryptByPrivateKey(encryptKey, privateKey);
            }
            catch (Exception e) {
                boolean attempt = false;
                try {
                    LOGGER.info("[decrypt] attempt old privateKey  ...");
                    realEncryptKey = RSAUtils.decryptByPrivateKey(encryptKey, CipherWrapper.getOldPrivateKey(partnerId, merchantId));
                    attempt = true;
                }
                catch (Exception e1) {
                    LOGGER.warn("[decrypt] attempt old privateKey fail", (Object)e1.getMessage());
                }
                if (attempt) break block9;
                throw new UnknownException(e);
            }
        }
        try {
            realData = AESUtils.decryptFromBase64(data, realEncryptKey);
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return StringUtils.isBlank((CharSequence)realData) ? null : JSON.parseObject(realData);
    }
}

