/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigurationUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtils.class);
    private static boolean customSource;
    private static final String PUBLIC = ".public";
    public static final String CONFIG_FILE = "5upay-config.properties";

    private static String getString(String key) {
        String value = StringUtils.trim((String)Holder.config.getString(key));
        if (StringUtils.isBlank((CharSequence)value)) {
            LOGGER.warn("ConfigurationUtils.getString:[" + key + "] is blank");
        }
        return value;
    }

    private static Integer getInteger(String key, Integer defaultValue) {
        Integer value = Holder.config.getInteger(key, defaultValue);
        return value;
    }

    public static String getPublicKey(String merchantId) {
        return ConfigurationUtils.getString(merchantId + PUBLIC);
    }

    public static String getHmacKey(String merchantId) {
        return ConfigurationUtils.getString(merchantId);
    }

    public static String getForeignExchangeOrderUrl() {
        return ConfigurationUtils.getString("foreignexchange.order.url");
    }

    public static String getForeignExchangeQueryUrl() {
        return ConfigurationUtils.getString("foreignexchange.query.url");
    }

    public static String getForeignExchangeRefundUrl() {
        return ConfigurationUtils.getString("foreignexchange.refund.url");
    }

    public static String getForeignExchangeRefundQueryUrl() {
        return ConfigurationUtils.getString("foreignexchange.refund.query.url");
    }

    public static String getForeignExchangeListpriceLockUrl() {
        return ConfigurationUtils.getString("foreignexchange.listpricelock.url");
    }

    public static String getForeignExchangeTransferOrderUrl() {
        return ConfigurationUtils.getString("foreignexchange.transfer.order.url");
    }

    public static String getForeignExchangeTransferQueryUrl() {
        return ConfigurationUtils.getString("foreignexchange.transfer.query.url");
    }

    public static String getOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("onlinepay.order.url");
    }

    public static String getOnlinePaySplitOrderUrl() {
        return ConfigurationUtils.getString("onlinepay.split.order.url");
    }

    public static String getOnlinePaySplitOrderQueryUrl() {
        return ConfigurationUtils.getString("onlinepay.split.order.query.url");
    }

    public static String getOnlinePayQueryUrl() {
        return ConfigurationUtils.getString("onlinepay.query.url");
    }

    public static String getOnlinePayRefundUrl() {
        return ConfigurationUtils.getString("onlinepay.refund.url");
    }

    public static String getOnlinePayRefundQueryUrl() {
        return ConfigurationUtils.getString("onlinepay.refund.query.url");
    }

    public static String getTransferOrderUrl() {
        return ConfigurationUtils.getString("transfer.order.url");
    }

    public static String getTransferQueryUrl() {
        return ConfigurationUtils.getString("transfer.query.url");
    }

    public static String getTransferValidateUrl() {
        return ConfigurationUtils.getString("transfer.validate.url");
    }

    public static String getTransferValidateQueryUrl() {
        return ConfigurationUtils.getString("transfer.validate.query.url");
    }

    public static String getTransferListpriceLockUrl() {
        return ConfigurationUtils.getString("transfer.listpricelock.url");
    }

    public static String getHgOrderUrl() {
        return ConfigurationUtils.getString("hg.order.url");
    }

    public static String getHgMemberUrl() {
        return ConfigurationUtils.getString("hg.member.url");
    }

    public static String getHgMemberQueryUrl() {
        return ConfigurationUtils.getString("hg.member.query.url");
    }

    public static String getHgQueryUrl() {
        return ConfigurationUtils.getString("hg.query.url");
    }

    public static String getHgPayOrderQueryUrl() {
        return ConfigurationUtils.getString("hg.pay.order.query");
    }

    public static String getBankChannelQueryUrl() {
        return ConfigurationUtils.getString("bankchannel.query.url");
    }

    public static String getCreditQueryOrderUrl() {
        return ConfigurationUtils.getString("rz.credit.url");
    }

    public static String getRzOrderUrl() {
        return ConfigurationUtils.getString("rz.auth.url");
    }

    public static String getRzQueryUrl() {
        return ConfigurationUtils.getString("rz.search.url");
    }

    public static String getQuickRechargeOrderUrl() {
        return ConfigurationUtils.getString("quickrecharge.order.url");
    }

    public static String getQuickRechargeUrl() {
        return ConfigurationUtils.getString("quickrecharge.query.url");
    }

    public static String getTransferDomesticOrderUrl() {
        return ConfigurationUtils.getString("transferDomestic.order.url");
    }

    public static String getTransferDomesticQueryUrl() {
        return ConfigurationUtils.getString("transferDomestic.query.url");
    }

    public static String getTransferAccountOrderUrl() {
        return ConfigurationUtils.getString("transferAccount.order.url");
    }

    public static String getTransferAccountQueryUrl() {
        return ConfigurationUtils.getString("transferAccount.query.url");
    }

    public static String getTransferDomesticGenerateTransferVoucherUrl() {
        return ConfigurationUtils.getString("transferDomestic.generateTransferVoucher.url");
    }

    public static String getTransferDomesticSingleOrderUrl() {
        return ConfigurationUtils.getString("transferDomestic.single.order.url");
    }

    public static String getTransferDomesticSingleQueryUrl() {
        return ConfigurationUtils.getString("transferDomestic.single.query.url");
    }

    public static String getTransferDomesticAccountAvailableBalanceUrl() {
        return ConfigurationUtils.getString("transferDomestic.account.availableBalance.url");
    }

    public static String getCustomsOrderUrl() {
        return ConfigurationUtils.getString("customs.order.url");
    }

    public static String getCustomsQueryUrl() {
        return ConfigurationUtils.getString("customs.query.url");
    }

    public static String getCustomsRepeatDeclareUrl() {
        return ConfigurationUtils.getString("customs.repeatDeclare.url");
    }

    public static String getHgTransferOrderURl() {
        return ConfigurationUtils.getString("hg.transferorder.url");
    }

    public static String getHgPayOrderUrl() {
        return ConfigurationUtils.getString("hg.payorder.url");
    }

    public static String getDestroyOrderUrl() {
        return ConfigurationUtils.getString("prepay.destroy.url");
    }

    public static String getDestroyQueryUrl() {
        return ConfigurationUtils.getString("prepay.destroyQuery.url");
    }

    public static String getPrepaySellOrderURl() {
        return ConfigurationUtils.getString("prepay.sell.order.url");
    }

    public static String getPrepaySellQueryURl() {
        return ConfigurationUtils.getString("prepay.sell.query.url");
    }

    public static String getRechareUrl() {
        return ConfigurationUtils.getString("hg.recharge.url");
    }

    public static String getRechareQueryUrl() {
        return ConfigurationUtils.getString("hg.recharge.query.url");
    }

    public static String getHgTransferQueryUrl() {
        return ConfigurationUtils.getString("hg.transfer.query.url");
    }

    public static String getHgAccountQueryUrl() {
        return ConfigurationUtils.getString("hg.account.query.url");
    }

    public static Integer getConnectTimeout() {
        return ConfigurationUtils.getInteger("ehking.sdk.net.client.defaultConnectTimeout", null);
    }

    public static Integer getReadTimeout() {
        return ConfigurationUtils.getInteger("ehking.sdk.net.client.defaultReadTimeout", null);
    }

    public static String getWithholdingOrderUrl() {
        return ConfigurationUtils.getString("withholding.order.url");
    }

    public static String getWithholdingQueryUrl() {
        return ConfigurationUtils.getString("withholding.query.url");
    }

    public static String getWithholdingOrderBatchUrl() {
        return ConfigurationUtils.getString("withholding.orderBatch.url");
    }

    public static String getForeignpayExchangesettlementOrderBatchUrl() {
        return ConfigurationUtils.getString("foreignpayExchangesettlement.orderBatch.url");
    }

    public static String getForeignpayExchangesettlementQueryBatchUrl() {
        return ConfigurationUtils.getString("foreignpayExchangesettlement.queryBatch.url");
    }

    public static String getPcardOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("prepaycard.order.url");
    }

    public static String getPcardOnlinePayQueryUrl() {
        return ConfigurationUtils.getString("prepaycard.query.url");
    }

    public static String getPcardBalanceCardQueryUrl() {
        return ConfigurationUtils.getString("prepaycard.balance.card.query.url");
    }

    public static String getPcardDestroyCardQueryUrl() {
        return ConfigurationUtils.getString("prepaycard.destroy.card.query.url");
    }

    public static String getMemberBalanceQueryUrl() {
        return ConfigurationUtils.getString("member.query.balance.url");
    }

    public static String getPhoenixOrderUrl() {
        return ConfigurationUtils.getString("phoenix.order.url");
    }

    public static String getPhoenixReportUrl() {
        return ConfigurationUtils.getString("phoenix.report.url");
    }

    public static String getPhoenixQueryUrl() {
        return ConfigurationUtils.getString("phoenix.query.url");
    }

    public static String getPhoenixRefundUrl() {
        return ConfigurationUtils.getString("phoenix.refund.url");
    }

    public static String getPhoenixRefundQueryUrl() {
        return ConfigurationUtils.getString("phoenix.refund.query.url");
    }

    public static String getPhoenixUserCreateUrl() {
        return ConfigurationUtils.getString("phoenix.user.create.url");
    }

    public static String getPhoenixUserQueryUrl() {
        return ConfigurationUtils.getString("phoenix.user.query.url");
    }

    public static String getJointUploadQualificationUrl() {
        return ConfigurationUtils.getString("joint.upload.qualification.url");
    }

    public static String getJointaccountCreateUrl() {
        return ConfigurationUtils.getString("joint.create.url");
    }

    public static String getJointaccountQueryCreateUrl() {
        return ConfigurationUtils.getString("joint.query.url");
    }

    public static String getJAccountQueryCreateUrl() {
        return ConfigurationUtils.getString("joint.query.jaccount.url");
    }

    public static String getJointQualificationQueryUrl() {
        return ConfigurationUtils.getString("joint.qualification.query.url");
    }

    public static String getJointTransferOrderCreateUrl() {
        return ConfigurationUtils.getString("joint.transfer.order.create.url");
    }

    public static String getJointTransferOrderQueryUrl() {
        return ConfigurationUtils.getString("joint.transfer.order.query.url");
    }

    public static String getJointSettlementProfileUrl() {
        return ConfigurationUtils.getString("joint.settlement.profile.url");
    }

    public static String getJointSettlementProfileQueryUrl() {
        return ConfigurationUtils.getString("joint.settlement.profile.query.url");
    }

    public static String getJointOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("joint.onlinepay.order.url");
    }

    public static String getReportModifyUrl() {
        return ConfigurationUtils.getString("phoenix.report.modify.url");
    }

    public static String getWeilianbaoModifyUrl() {
        return StringUtils.trim((String)Holder.config.getString("phoenix.weilianbao.modify.url"));
    }

    public static String getProxyOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("proxy.onlinePay.order.url");
    }

    public static String getHttpContentType() {
        return ConfigurationUtils.getString("http.content.type");
    }

    public static String getHttpContentTypeV2() {
        return ConfigurationUtils.getString("http.content.type.v2");
    }

    public static String getHttpContentTypeV3() {
        return ConfigurationUtils.getString("http.content.type.v3");
    }

    public static String getConsumerFinanceOrderUrl() {
        return ConfigurationUtils.getString("consumerFinance.order.url");
    }

    public static String getConsumerFinanceRepaymentQueryUrl() {
        return ConfigurationUtils.getString("consumerFinance.repayment.query.url");
    }

    public static String getConsumerFinanceOrderQueryUrl() {
        return ConfigurationUtils.getString("consumerFinance.order.query.url");
    }

    public static String getPhoenixUnBindCardUrl() {
        return ConfigurationUtils.getString("phoenix.unbind.url");
    }

    public static String getPhoenixBindCardUrl() {
        return ConfigurationUtils.getString("phoenix.bind.url");
    }

    public static String getPhoenixBindCardConfirmUrl() {
        return ConfigurationUtils.getString("phoenix.bindConfirm.url");
    }

    public static String getPhoenixBindCardQueryUrl() {
        return ConfigurationUtils.getString("phoenix.bindQuery.url");
    }

    public static String getServerPublicKey() {
        return ConfigurationUtils.getString("server.public.key.path");
    }

    public static String getClientPrivateKeyPath(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.private.key.path");
    }

    public static String getClientPrivateKeyPassword(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.private.key.password");
    }

    public static String getErtTradeRemitOrderUrl() {
        return ConfigurationUtils.getString("ert.trade.remit.order.url");
    }

    public static String getErtTradeRemitOrderQueryUrl() {
        return ConfigurationUtils.getString("ert.trade.remit.order.query.url");
    }

    public static String getErtBindCardUrl() {
        return ConfigurationUtils.getString("ert.bindcard.request.url");
    }

    public static String getErtBindCardConfirmUrl() {
        return ConfigurationUtils.getString("ert.bindcard.confirm.url");
    }

    public static String getErtBindCardQueryUrl() {
        return ConfigurationUtils.getString("ert.bindcard.query.url");
    }

    public static String getErtUnBindCardUrl() {
        return ConfigurationUtils.getString("ert.bindcard.unbind.url");
    }

    public static String getErtBindCardUrlV2() {
        return ConfigurationUtils.getString("ert.v2.bindcard.request.url");
    }

    public static String getErtBindCardConfirmUrlV2() {
        return ConfigurationUtils.getString("ert.v2.bindcard.confirm.url");
    }

    public static String getErtBindCardQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.bindcard.query.url");
    }

    public static String getErtUnBindCardUrlV2() {
        return ConfigurationUtils.getString("ert.v2.bindcard.unbind.url");
    }

    public static String getErtReceiptOrderUrlV2() {
        return ConfigurationUtils.getString("ert.v2.order.url");
    }

    public static String getErtOrderQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.query.url");
    }

    public static String getErtReceiptPaymentUrlV2() {
        return ConfigurationUtils.getString("ert.v2.order.payment.url");
    }

    public static String getErtUserLaunchRemitOrderUrlV2() {
        return ConfigurationUtils.getString("ert.v2.user.remit.url");
    }

    public static String getErtUserLaunchTradeRemitQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.user.remit.query.url");
    }

    public static String getErtMerchantCommissionRemitUrlV2() {
        return ConfigurationUtils.getString("ert.v2.merchant.remit.url");
    }

    public static String getErtMerchantCommissionRemitQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.merchant.remit.query.url");
    }

    public static String getErtUserBalanceQueryUrlV2() {
        return ConfigurationUtils.getString("ert.v2.user.balance.query.url");
    }

    public static String getErtUserSignUp() {
        return ConfigurationUtils.getString("ert.user.signUp.url");
    }

    public static String getErtOrderUrl() {
        return ConfigurationUtils.getString("ert.order.url");
    }

    public static String getErtQueryUrl() {
        return ConfigurationUtils.getString("ert.query.url");
    }

    public static String getErtQuerySubMerchantUrl() {
        return ConfigurationUtils.getString("ert.query.submerchant.url");
    }

    public static String getErtCommissionRemitOrderUrl() {
        return ConfigurationUtils.getString("ert.commission.remit.order.url");
    }

    public static String getErtCommissionRemitOrderQueryUrl() {
        return ConfigurationUtils.getString("ert.commission.remit.order.query.url");
    }

    public static String getErtUserBalanceQueryUrl() {
        return ConfigurationUtils.getString("ert.user.balance.query.url");
    }

    public static String getNewRetailSplitOrderUrl() {
        return ConfigurationUtils.getString("newretail.split.order.url");
    }

    public static String getNewRetailOrderUrl() {
        return ConfigurationUtils.getString("newretail.create.order.url");
    }

    public static String getNewRetailOrderQueryUrl() {
        return ConfigurationUtils.getString("newretail.query.order.url");
    }

    public static String getNewRetailOrderRefundUrl() {
        return ConfigurationUtils.getString("newretail.order.refund.url");
    }

    public static String getNewRetailOrderRefundQueryUrl() {
        return ConfigurationUtils.getString("newretail.order.refund.query.url");
    }

    public static String getNewRetailOrderExtendGuaranteeUrl() {
        return ConfigurationUtils.getString("newretail.order.extend.guarantee.url");
    }

    public static String getNewRetailQueryAccountUrl() {
        return ConfigurationUtils.getString("newretail.query.account.url");
    }

    public static String getNewRetailGuaranteeFinishUrl() {
        return ConfigurationUtils.getString("newretail.order.guarantee.complete.url");
    }

    public static String getNewRetailBindCardUrl() {
        return ConfigurationUtils.getString("newretail.bindCard.request.url");
    }

    public static String getNewRetailBindCardConfirmUrl() {
        return ConfigurationUtils.getString("newretail.bindCard.confirm.url");
    }

    public static String getNewRetailBindCardQueryUrl() {
        return ConfigurationUtils.getString("newretail.bindCard.query.url");
    }

    public static String getNewRetailUnBindCardUrl() {
        return ConfigurationUtils.getString("newretail.bindCard.unbind.url");
    }

    public static String getNewRetailSubsidyOrderUrl() {
        return ConfigurationUtils.getString("newretail.subsidy.order.url");
    }

    public static String getNewRetailSubsidyOrderQueryUrl() {
        return ConfigurationUtils.getString("newretail.subsidy.orderQuery.url");
    }

    public static String getNewRetailSubsidyRefundUrl() {
        return ConfigurationUtils.getString("newretail.subsidy.refund.url");
    }

    public static String getNewRetailSubsidyRefundQueryUrl() {
        return ConfigurationUtils.getString("newretail.subsidy.refundQuery.url");
    }

    public static String getErtCommissionBalanceQueryUrl() {
        return ConfigurationUtils.getString("ert.commission.balance.query.url");
    }

    public static String getCashierBindCardQueryUrl() {
        return ConfigurationUtils.getString("cashier.bindcard.query.url");
    }

    public static String getCashierBindCardUrl() {
        return ConfigurationUtils.getString("cashier.bindcard.url");
    }

    public static String getCashierBindCardConfirmUrl() {
        return ConfigurationUtils.getString("cashier.bindcard.confirm.url");
    }

    public static String getCashierBindCardKaptchaUrl() {
        return ConfigurationUtils.getString("cashier.bindcard.kaptcha.url");
    }

    public static String getCashierUnBindCardUrl() {
        return ConfigurationUtils.getString("cashier.unbindcard.url");
    }

    public static String getCashierReceiptPaymentUrl() {
        return ConfigurationUtils.getString("cashier.receipt.payment.url");
    }

    public static String getDeclarationSubMerchantDeclareUrl() {
        return ConfigurationUtils.getString("declaration.sub.merchant.declare.url");
    }

    public static String getDeclarationSubMerchantQueryUrl() {
        return ConfigurationUtils.getString("declaration.sub.merchant.query.url");
    }

    public static String getEshoppingGetPolicyUrl() {
        return ConfigurationUtils.getString("eshopping.getPolicy.url");
    }

    public static String getEshoppingOrderUrl() {
        return ConfigurationUtils.getString("eshopping.order.url");
    }

    public static String getEshoppingPayUrl() {
        return ConfigurationUtils.getString("eshopping.pay.url");
    }

    public static String getEshoppingQueryUrl() {
        return ConfigurationUtils.getString("eshopping.query.url");
    }

    public static String getEshoppingVccRechargeUrl() {
        return ConfigurationUtils.getString("eshopping.vccRecharge.url");
    }

    public static String getEshoppingApplyVccCardUrl() {
        return ConfigurationUtils.getString("eshopping.applyVccCard.url");
    }

    public static String getEshoppingQueryApplyVccCardUrl() {
        return ConfigurationUtils.getString("eshopping.queryApplyVccCard.url");
    }

    public static String getEshoppingCancelVccCardUrl() {
        return ConfigurationUtils.getString("eshopping.cancelVccCard.url");
    }

    public static String getEshoppingVccCardOrderServiceUrl() {
        return ConfigurationUtils.getString("eshopping.vccCardOrderService.url");
    }

    public static String getEshoppingCancelVccCardQueryUrl() {
        return ConfigurationUtils.getString("eshopping.cancelVccCardQuery.url");
    }

    public static String getEshoppingVccExpenseCreateUrl() {
        return ConfigurationUtils.getString("eshopping.vccExpenseCreate.url");
    }

    public static String getEshoppingVccExpenseQueryUrl() {
        return ConfigurationUtils.getString("eshopping.vccExpenseQuery.url");
    }

    public static String getEshoppingGetListPriceUrl() {
        return ConfigurationUtils.getString("eshopping.getListPrice.url");
    }

    public static String getEshoppingTransferAmountUrl() {
        return ConfigurationUtils.getString("eshopping.getTransferAmount.url");
    }

    public static String getEshoppingVccMerchantTradeOrderUrl() {
        return ConfigurationUtils.getString("eshopping.vccMerchantTradeOrder.url");
    }

    public static String getSettlementOrderUrl() {
        return ConfigurationUtils.getString("settlement.order.url");
    }

    public static String getBillingOrderUrl() {
        return ConfigurationUtils.getString("billing.order.url");
    }

    public static String getSettlementRuleQueryUrl() {
        return ConfigurationUtils.getString("settlement.rule.query.url");
    }

    public static String getWalletWithdrawUrl() {
        return ConfigurationUtils.getString("wallet.withdraw.url");
    }

    public static String getWalletWithdrawQueryUrl() {
        return ConfigurationUtils.getString("wallet.withdraw.query.url");
    }

    public static String getIccConsumeApiOrderUrl() {
        return ConfigurationUtils.getString("icc.order.api.url");
    }

    public static String getIccQueryOrderUrl() {
        return ConfigurationUtils.getString("icc.order.query.url");
    }

    public static String getIccPreauthConfirmUrl() {
        return ConfigurationUtils.getString("icc.order.preauthconfirm.url");
    }

    public static String getIccCashierOrderUrl() {
        return ConfigurationUtils.getString("icc.order.cashier.url");
    }

    public static String getIccOrderRefundUrl() {
        return ConfigurationUtils.getString("icc.order.refund.url");
    }

    public static String getIccRefundQueryUrl() {
        return ConfigurationUtils.getString("icc.refund.query.url");
    }

    public static String getIccOrderDeliveryUrl() {
        return ConfigurationUtils.getString("icc.order.delivery.url");
    }

    public static void setProperty(String key, Object value) {
        Holder.config.setProperty(key, value);
    }

    public static void setConfigSource(Configuration configSource) {
        if (configSource == null) {
            throw new IllegalArgumentException("configSource is null");
        }
        customSource = true;
        Holder.config = configSource;
    }

    public static String getWeboxRechargeUrl() {
        return ConfigurationUtils.getString("webox.recharge.create.url");
    }

    public static String getWeboxRechargeQueryUrl() {
        return ConfigurationUtils.getString("webox.recharge.query.url");
    }

    public static String getWeboxMerchantRechargeUrl() {
        return ConfigurationUtils.getString("webox.merchantRecharge.create.url");
    }

    public static String getWeboxMerchantRechargeBatchUrl() {
        return ConfigurationUtils.getString("webox.merchantRechargeBatch.create.url");
    }

    public static String getWeboxMerchantRechargeQueryUrl() {
        return ConfigurationUtils.getString("webox.merchantRecharge.query.url");
    }

    public static String getWeboxTransferCreateUrl() {
        return ConfigurationUtils.getString("webox.transfer.create.url");
    }

    public static String getWeboxOnlinePayCreateUrl() {
        return ConfigurationUtils.getString("webox.onlinepay.create.url");
    }

    public static String getWeboxOnlinePayQueryUrl() {
        return ConfigurationUtils.getString("webox.onlinepay.query.url");
    }

    public static String getWeboxOnlinePayRefundUrl() {
        return ConfigurationUtils.getString("webox.onlinepay.refund.url");
    }

    public static String getWeboxOnlinePayRefundQueryUrl() {
        return ConfigurationUtils.getString("webox.onlinepay.refund.query.url");
    }

    public static String getGetListPriceUrl() {
        return ConfigurationUtils.getString("listprice.getListPrice.url");
    }

    public static String getWeboxTransferConfirmUrl() {
        return ConfigurationUtils.getString("webox.transfer.confirm.url");
    }

    public static String getWeboxTransferRefuseUrl() {
        return ConfigurationUtils.getString("webox.transfer.refuse.url");
    }

    public static String getWeboxTransferQueryUrl() {
        return ConfigurationUtils.getString("webox.transfer.query.url");
    }

    public static String getWeboxTransferTimeoutReturnUrl() {
        return ConfigurationUtils.getString("webox.transfer.timeoutReturn.url");
    }

    public static String getWeboxWithholdingUrl() {
        return ConfigurationUtils.getString("webox.withholding.create.url");
    }

    public static String getWeboxWithholdingQueryUrl() {
        return ConfigurationUtils.getString("webox.withholding.query.url");
    }

    public static String getWeboxRedPacketUrl() {
        return ConfigurationUtils.getString("webox.redpacket.create.url");
    }

    public static String getWeboxRedPacketQueryUrl() {
        return ConfigurationUtils.getString("webox.redpacket.query.url");
    }

    public static String getWeboxRedPacketGrabUrl() {
        return ConfigurationUtils.getString("webox.redpacket.grab.url");
    }

    public static String getWeboxRedPacketTimeoutReturnUrl() {
        return ConfigurationUtils.getString("webox.redpacket.timeoutReturn.url");
    }

    public static String getWeboxWalletUpdateWalletInfoUrl() {
        return ConfigurationUtils.getString("webox.wallet.updateWallet.url");
    }

    public static String getWeboxWalletCreateGrabUrl() {
        return ConfigurationUtils.getString("webox.wallet.create.url");
    }

    public static String getWeboxBindCardSyncUrl() {
        return ConfigurationUtils.getString("webox.bindcard.sync.url");
    }

    public static String getWeboxClientTokenCreateUrl() {
        return ConfigurationUtils.getString("webox.clienttoken.create.url");
    }

    public static String getWeboxValueAddedCreateUrl() {
        return ConfigurationUtils.getString("webox.value.added.create.url");
    }

    public static String getWeboxValueAddedQueryUserInfoUrl() {
        return ConfigurationUtils.getString("webox.value.added.query.userinfo.url");
    }

    public static String getWeboxWalletUpdateMobileUrl() {
        return ConfigurationUtils.getString("webox.wallet.updateMobile.url");
    }

    public static String getWeboxWalletQueryGrabUrl() {
        return ConfigurationUtils.getString("webox.wallet.query.url");
    }

    public static String getWeboxTradeRecordQueryUrl() {
        return ConfigurationUtils.getString("webox.tradeRecord.query.url");
    }

    public static String getWeboxTradeStatisUrl() {
        return ConfigurationUtils.getString("webox.tradeRecord.statis.url");
    }

    public static String getWeboxTradeRecordDeleteUrl() {
        return ConfigurationUtils.getString("webox.tradeRecord.delete.url");
    }

    public static String getWeboxBillQueryUrl() {
        return ConfigurationUtils.getString("webox.bill.query.url");
    }

    public static String getWeboxBillDetailQueryUrl() {
        return ConfigurationUtils.getString("webox.bill.detail.query.url");
    }

    public static String getWeboxRedPacketBillQueryUrl() {
        return ConfigurationUtils.getString("webox.redpacket.bill.query.url");
    }

    public static String getWeboxAccountHistoryQueryUrl() {
        return ConfigurationUtils.getString("webox.account.history.url");
    }

    public static String getWeboxRedPacketGrabHistoryUrl() {
        return ConfigurationUtils.getString("webox.redpacket.grab.history.url");
    }

    public static String getWeboxWalletSafeCreateToken() {
        return ConfigurationUtils.getString("webox.wallet.safe.create.token.url");
    }

    public static String getWeboxPayPasswordValidateCreate() {
        return ConfigurationUtils.getString("webox.pay.password.validate.create.url");
    }

    public static String getWeboxPayPasswordValidateQuery() {
        return ConfigurationUtils.getString("webox.pay.password.validate.query.url");
    }

    public static String getHttpContentEncoding() {
        return ConfigurationUtils.getString("http.content.type.encoding");
    }

    public static String getEshoppingHistoryConsumeUrl() {
        return ConfigurationUtils.getString("eshopping.getHistoryConsume.url");
    }

    public static String getEshoppingAvailableBalanceUrl() {
        return ConfigurationUtils.getString("eshopping.getAvailableBalance.url");
    }

    public static String getEshoppingMerchantListPriceUrl() {
        return ConfigurationUtils.getString("eshopping.getMerchantListPrice.url");
    }

    public static String getEasePayCreateOrderUrl() {
        return ConfigurationUtils.getString("easepay.create.order.url");
    }

    public static String getEshoppingMiddleMerchantApplyCardUrl() {
        return ConfigurationUtils.getString("eshopping.middle.merchant.applyVccCard.url");
    }

    public static String getEshoppingQueryMiddleMerchantApplyCardUrl() {
        return ConfigurationUtils.getString("eshopping.middle.merchant.queryApplyVccCard.url");
    }

    public static String getWeboxTradeStatUrl() {
        return ConfigurationUtils.getString("webox.trade.stat.url");
    }

    public static String getWeboxRedpacketTradeStatUrl() {
        return ConfigurationUtils.getString("webox.trade.redpacket.stat.url");
    }

    public static String getOldClientPrivateKeyPath(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.old.private.key.path");
    }

    public static String getOldClientPrivateKeyPassword(String merchantId) {
        return ConfigurationUtils.getString(merchantId + ".client.old.private.key.password");
    }

    public static String getServiceProviderDeclarationUrl() {
        return ConfigurationUtils.getString("serviceprovider.declaration.url");
    }

    public static String getServiceProviderDeclarationQueryUrl() {
        return ConfigurationUtils.getString("serviceprovider.declaration.query.url");
    }

    public static String getServiceProviderReSendMsUrl() {
        return ConfigurationUtils.getString("serviceprovider.reSendMsg.url");
    }

    public static String getCpOnlinePayOrderUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.order.url");
    }

    public static String getCpOnlinePayQueryUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.query.url");
    }

    public static String getCpOnlinePayRefundUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.refund.url");
    }

    public static String getCpOnlinePayRefundQueryUrl() {
        return ConfigurationUtils.getString("cp.onlinepay.refund.query.url");
    }

    private static class Holder {
        public static Configuration config;

        private Holder() {
        }

        static {
            try {
                if (!customSource) {
                    config = new PropertiesConfiguration(ConfigurationUtils.CONFIG_FILE);
                }
            }
            catch (ConfigurationException e) {
                LOGGER.error("classpath:ehking-config.properties not found", (Throwable)e);
            }
        }
    }
}

