/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.tls.support_1_6.TLSSocketConnectionFactory;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClientUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(HttpClientUtils.class);
    protected static final String CONTENT_TYPE = ConfigurationUtils.getHttpContentType();
    protected static final String CONTENT_TYPE_V2 = ConfigurationUtils.getHttpContentTypeV2();
    protected static final String CONTENT_TYPE_V3 = ConfigurationUtils.getHttpContentTypeV3();
    protected static final String CHARSET = "UTF-8";
    protected static final String CONTENT_ENCODING_ZIP = "gzip";
    protected static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String CN_LANGUAGE = "zh-CN";
    private static final String US_LANGUAGE = "en-US";
    static HostnameVerifier sslHostnameVerifier = HttpClientUtils.createHostnameVerifier();
    static SSLSocketFactory sslSocketFactory = HttpClientUtils.createSSLSocketFactory();
    private static final String ENCRYPT_KEY = "encryptKey";
    private static final String MERCHANT_ID = "merchantId";
    private static final String REQUEST_ID = "requestId";
    private static final String PARTNER_ID = "partnerId";
    private static final String DATA = "data";
    private static final String HTTP_STATUS = "httpStatus";

    private static HttpURLConnection createConnection(String urlStr) throws IOException {
        Integer connectTimeout;
        HttpURLConnection con = null;
        URL url = new URL(urlStr);
        con = (HttpURLConnection)url.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setUseCaches(false);
        con.setInstanceFollowRedirects(false);
        con.setRequestMethod("POST");
        con.setRequestProperty("charset", CHARSET);
        con.setRequestProperty("User-Agent", "SDK/2.0");
        con.setRequestProperty("Accept-Language", CN_LANGUAGE);
        con.setRequestProperty("Accept-Encoding", CONTENT_ENCODING_ZIP);
        con.setUseCaches(false);
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection httpsCon = (HttpsURLConnection)con;
            httpsCon.setHostnameVerifier(sslHostnameVerifier);
            httpsCon.setSSLSocketFactory(sslSocketFactory);
        }
        if ((connectTimeout = ConfigurationUtils.getConnectTimeout()) != null) {
            con.setConnectTimeout(connectTimeout);
            LOGGER.info("set connectTimeout:[" + connectTimeout + "]");
        } else {
            LOGGER.info("not set connectTimeout:[" + connectTimeout + "]");
        }
        Integer readTimeout = ConfigurationUtils.getReadTimeout();
        if (readTimeout != null) {
            con.setReadTimeout(readTimeout);
            LOGGER.info("set readTimeout:[" + readTimeout + "]");
        } else {
            LOGGER.info("not set readTimeout:[" + connectTimeout + "]");
        }
        return con;
    }

    public static String post3(String urlStr, JSONObject data) {
        HttpURLConnection con = null;
        StringBuilder sb = new StringBuilder();
        JSONObject json = new JSONObject();
        int httpResult = 0;
        try {
            BufferedReader br;
            LOGGER.debug("data:[" + data.toJSONString() + "]");
            con = HttpClientUtils.createConnection(urlStr);
            con.setRequestProperty("Content-Type", CONTENT_TYPE_V3);
            Object encryptKeyObj = data.remove(ENCRYPT_KEY);
            String encryptKey = encryptKeyObj == null ? null : String.valueOf(encryptKeyObj);
            Object merchantIdObj = data.remove(MERCHANT_ID);
            String merchantId = merchantIdObj == null ? null : String.valueOf(merchantIdObj);
            Object requestIdObj = data.remove(REQUEST_ID);
            String requestId = requestIdObj == null ? null : String.valueOf(requestIdObj);
            Object partnerIdObj = data.remove(PARTNER_ID);
            String partnerId = partnerIdObj == null ? null : String.valueOf(partnerIdObj);
            Object dataObj = data.remove(DATA);
            String body = dataObj == null ? null : String.valueOf(dataObj);
            con.setRequestProperty(ENCRYPT_KEY, encryptKey);
            con.setRequestProperty(MERCHANT_ID, merchantId);
            if (StringUtils.isNotBlank((CharSequence)requestId)) {
                con.setRequestProperty(REQUEST_ID, requestId);
            }
            if (StringUtils.isNotBlank((CharSequence)partnerId)) {
                con.setRequestProperty(PARTNER_ID, partnerId);
            }
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.write(body.getBytes(CHARSET));
            wr.flush();
            wr.close();
            httpResult = con.getResponseCode();
            json.put(HTTP_STATUS, (Object)httpResult);
            if (httpResult == 200) {
                br = HttpClientUtils.getBufferedReader(con);
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
            } else {
                if (httpResult == 406) {
                    throw new HttpResponseException(httpResult, "Data error, Access denied. Http status is 406 !");
                }
                throw new HttpResponseException(httpResult, con.getResponseMessage());
            }
            br.close();
            String ek = con.getHeaderField(ENCRYPT_KEY);
            String mid = con.getHeaderField(MERCHANT_ID);
            String pid = con.getHeaderField(PARTNER_ID);
            json = JSONObject.parseObject(sb.toString());
            json.put(ENCRYPT_KEY, (Object)ek);
            json.put(MERCHANT_ID, (Object)mid);
            if (StringUtils.isNotBlank((CharSequence)pid)) {
                json.put(PARTNER_ID, (Object)pid);
            }
        }
        catch (Exception e) {
            LOGGER.info("http response urlStr[{}] status[{}]", (Object)urlStr, (Object)httpResult);
            throw new UnknownException(e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return json.toJSONString();
    }

    public static String post2(String urlStr, JSONObject data) {
        HttpURLConnection con = null;
        StringBuilder sb = new StringBuilder();
        JSONObject json = new JSONObject();
        int httpResult = 0;
        try {
            BufferedReader br;
            LOGGER.debug("data:[" + data.toJSONString() + "]");
            con = HttpClientUtils.createConnection(urlStr);
            con.setRequestProperty("Content-Type", CONTENT_TYPE_V2);
            Object encryptKeyObj = data.remove(ENCRYPT_KEY);
            String encryptKey = encryptKeyObj == null ? null : String.valueOf(encryptKeyObj);
            Object merchantIdObj = data.remove(MERCHANT_ID);
            String merchantId = merchantIdObj == null ? null : String.valueOf(merchantIdObj);
            Object requestIdObj = data.remove(REQUEST_ID);
            String requestId = requestIdObj == null ? null : String.valueOf(requestIdObj);
            Object partnerIdObj = data.remove(PARTNER_ID);
            String partnerId = partnerIdObj == null ? null : String.valueOf(partnerIdObj);
            Object dataObj = data.remove(DATA);
            String body = dataObj == null ? null : String.valueOf(dataObj);
            con.setRequestProperty(ENCRYPT_KEY, encryptKey);
            con.setRequestProperty(MERCHANT_ID, merchantId);
            if (StringUtils.isNotBlank((CharSequence)requestId)) {
                con.setRequestProperty(REQUEST_ID, requestId);
            }
            if (StringUtils.isNotBlank((CharSequence)partnerId)) {
                con.setRequestProperty(PARTNER_ID, partnerId);
            }
            DataOutputStream wr = new DataOutputStream(con.getOutputStream());
            wr.write(body.getBytes(CHARSET));
            wr.flush();
            wr.close();
            httpResult = con.getResponseCode();
            json.put(HTTP_STATUS, (Object)httpResult);
            if (httpResult == 200) {
                br = HttpClientUtils.getBufferedReader(con);
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
            } else {
                if (httpResult == 406) {
                    throw new HttpResponseException(httpResult, "Data error, Access denied. Http status is 406 !");
                }
                throw new HttpResponseException(httpResult, con.getResponseMessage());
            }
            br.close();
            String ek = con.getHeaderField(ENCRYPT_KEY);
            String mid = con.getHeaderField(MERCHANT_ID);
            String pid = con.getHeaderField(PARTNER_ID);
            json = JSONObject.parseObject(sb.toString());
            json.put(ENCRYPT_KEY, (Object)ek);
            json.put(MERCHANT_ID, (Object)mid);
            if (StringUtils.isNotBlank((CharSequence)pid)) {
                json.put(PARTNER_ID, (Object)pid);
            }
        }
        catch (Exception e) {
            LOGGER.info("http response urlStr[{}] status[{}]", (Object)urlStr, (Object)httpResult);
            throw new UnknownException(e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return json.toJSONString();
    }

    public static String post(String urlStr, String data) {
        StringBuilder sb;
        block8: {
            HttpURLConnection con = null;
            sb = new StringBuilder();
            int httpResult = 0;
            try {
                con = HttpClientUtils.createConnection(urlStr);
                con.setRequestProperty("Content-Type", CONTENT_TYPE);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.write(data.getBytes(CHARSET));
                wr.flush();
                wr.close();
                httpResult = con.getResponseCode();
                if (httpResult == 200) {
                    BufferedReader br = HttpClientUtils.getBufferedReader(con);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    break block8;
                }
                throw new HttpResponseException(httpResult, con.getResponseMessage());
            }
            catch (Exception e) {
                LOGGER.info("http response urlStr[{}] status[{}]", (Object)urlStr, (Object)httpResult);
                throw new UnknownException(e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        return sb.toString();
    }

    public static String post(String urlStr, String data, String language) {
        StringBuilder sb;
        block8: {
            LOGGER.info("data:[" + data + "]");
            HttpURLConnection con = null;
            sb = new StringBuilder();
            int httpResult = 0;
            try {
                con = HttpClientUtils.createConnection(urlStr);
                con.setRequestProperty("Content-Type", CONTENT_TYPE);
                LOGGER.info("language:[" + language + "]");
                String strLanguage = language.replace("_", "-");
                con.setRequestProperty("Accept-Language", strLanguage);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.write(data.getBytes(CHARSET));
                wr.flush();
                wr.close();
                httpResult = con.getResponseCode();
                if (httpResult == 200) {
                    BufferedReader br = HttpClientUtils.getBufferedReader(con);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    break block8;
                }
                throw new HttpResponseException(httpResult, con.getResponseMessage());
            }
            catch (Exception e) {
                LOGGER.info("http response urlStr[{}] status[{}]", (Object)urlStr, (Object)httpResult);
                throw new UnknownException(e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        return sb.toString();
    }

    public static String notify(String urlStr, String data) {
        StringBuilder sb;
        block8: {
            HttpURLConnection con = null;
            sb = new StringBuilder();
            try {
                con = HttpClientUtils.createConnection(urlStr);
                DataOutputStream wr = new DataOutputStream(con.getOutputStream());
                wr.write(data.getBytes(CHARSET));
                wr.flush();
                wr.close();
                int HttpResult = con.getResponseCode();
                if (HttpResult == 200) {
                    BufferedReader br = HttpClientUtils.getBufferedReader(con);
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    br.close();
                    break block8;
                }
                throw new HttpResponseException(HttpResult, con.getResponseMessage());
            }
            catch (Exception e) {
                throw new UnknownException(e);
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
        return sb.toString();
    }

    private static HostnameVerifier createHostnameVerifier() {
        return new HostnameVerifier(){

            @Override
            public boolean verify(String urlHostName, SSLSession session) {
                return true;
            }
        };
    }

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory sslSocketFactory = null;
        try {
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.startsWith("1.6")) {
                sslSocketFactory = new TLSSocketConnectionFactory();
            } else {
                SSLContext context = SSLContext.getInstance("TLSv1.2");
                X509TrustManager trustManager = new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }
                };
                context.init(null, new TrustManager[]{trustManager}, new SecureRandom());
                sslSocketFactory = context.getSocketFactory();
            }
        }
        catch (Exception e) {
            LOGGER.error("createSSLSocketFactory", (Throwable)e);
        }
        return sslSocketFactory;
    }

    private static BufferedReader getBufferedReader(HttpURLConnection con) throws IOException {
        String headerEncoding = con.getHeaderField(HEADER_CONTENT_ENCODING);
        BufferedReader br = CONTENT_ENCODING_ZIP.equals(headerEncoding) ? new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(con.getInputStream()), CHARSET)) : new BufferedReader(new InputStreamReader(con.getInputStream(), CHARSET));
        return br;
    }
}

