/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PrepayConfigurationUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(PrepayConfigurationUtils.class);
    public static final String CONFIG_FILE = "prepay-config.properties";

    public static String getGrantPublicKey(String merchantId) {
        return Holder.config.getString(merchantId + "grantPublicKey");
    }

    public static String getPrivateKey(String merchantId) {
        return Holder.config.getString(merchantId + "privateKey");
    }

    public static void setProperty(String key, Object value) {
        Holder.config.setProperty(key, value);
    }

    public static void setConfigSource(Configuration configSource) {
        Holder.config = configSource;
    }

    private static class Holder {
        public static Configuration config;

        private Holder() {
        }

        static {
            try {
                config = new PropertiesConfiguration(PrepayConfigurationUtils.CONFIG_FILE);
            }
            catch (ConfigurationException e) {
                LOGGER.error("classpath:prepay-config.properties not found", (Throwable)e);
            }
        }
    }
}

