/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.cashier.bindcard.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.cashier.bindcard.builder.BindCardBuilder;
import com.upay.sdk.cashier.bindcard.builder.BindCardConfirmBuilder;
import com.upay.sdk.cashier.bindcard.builder.BindCardKaptchaBuilder;
import com.upay.sdk.cashier.bindcard.builder.BindCardQueryBuilder;
import com.upay.sdk.cashier.bindcard.builder.UnBindCardBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.exception.UnknownException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindCardExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(BindCardExecuter.class);

    public void bothBindCard(BindCardBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("BindCardExecuter bindCard requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCashierBindCardUrl(), requestData);
                LOGGER.info("BindCardExecuter bindCard responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("BindCardExecuter responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status) || Constants.REDIRECT.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("BindCardExecuter bothBindCard error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothBindCardConfirm(BindCardConfirmBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("BindCardExecuter bindCardConfirm requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCashierBindCardConfirmUrl(), requestData);
                LOGGER.info("BindCardExecuter bindCardConfirm responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("BindCardExecuter responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("BindCardExecuter bothBindCardConfirm error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothBindCardQuery(BindCardQueryBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.info("BindCardExecuter bindCardQuery requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCashierBindCardQueryUrl(), requestData);
                LOGGER.info("BindCardExecuter bindCardQuery responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("BindCardExecuter responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("BindCardExecuter bothBindCardQuery error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothUnbindCard(UnBindCardBuilder builder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = builder.bothEncryptBuild();
                LOGGER.debug("BindCardExecuter unbindCard requestData:[" + requestData.toJSONString() + "]");
                LOGGER.info("BindCardExecuter url:" + ConfigurationUtils.getCashierUnBindCardUrl());
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCashierUnBindCardUrl(), requestData);
                LOGGER.debug("BindCardExecuter unbindCard responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("BindCardExecuter responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.ERROR.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("BindCardExecuter bothUnbindCard error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void bothBindCardKaptcha(BindCardKaptchaBuilder bindCardKaptchaBuilder, ResultListener resultListener) {
        block5: {
            try {
                JSONObject requestData = bindCardKaptchaBuilder.bothEncryptBuild();
                LOGGER.info("BindCardExecuter bothBindCardKaptcha requestData:[" + requestData.toJSONString() + "]");
                String responseStr = HttpClientUtils.post3(ConfigurationUtils.getCashierBindCardKaptchaUrl(), requestData);
                LOGGER.info("BindCardExecuter bothBindCardKaptcha responseStr:[" + responseStr + "]");
                JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
                responseData = CipherWrapper.bothDecryptWrap(responseData);
                LOGGER.info("BindCardExecuter bothBindCardKaptcha responseStr:[" + responseData + "]");
                String status = responseData.getString(Constants.STATUS);
                if (Constants.ERROR.equals(status)) {
                    throw new ResponseException(responseData);
                }
                this.bothVerifyHmacOrder(responseData);
                if (Constants.SUCCESS.equals(status)) {
                    resultListener.success(responseData);
                    break block5;
                }
                if (Constants.FAILED.equals(status)) {
                    resultListener.failure(responseData);
                    break block5;
                }
                throw new ResponseException(responseData);
            }
            catch (Exception e) {
                LOGGER.error("BindCardExecuter bothBindCardKaptcha error", (Throwable)e);
                throw new UnknownException(e);
            }
        }
    }

    public void callBack(JSONObject responseData, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        JSONObject data = CipherWrapper.bothDecryptWrap(responseData);
        this.bothVerifyHmacOrder(data);
        String status = data.getString(Constants.BIND_STATUS);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            if (Constants.SUCCESS.equals(status)) {
                listener.success(data);
            } else {
                throw new ResponseException(data);
            }
        }
    }
}

