/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.consumerFinance.v_2.executer;

import com.alibaba.fastjson15.JSONObject;
import com.alibaba.fastjson15.parser.Feature;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.Constants;
import com.upay.sdk.HttpClientUtils;
import com.upay.sdk.consumerFinance.v_2.builder.OrderQueryBuilder;
import com.upay.sdk.exception.ResponseException;
import com.upay.sdk.executer.Executer;
import com.upay.sdk.executer.ResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderQueryExecuter
extends Executer {
    static final Logger LOGGER = LoggerFactory.getLogger(OrderQueryExecuter.class);

    public void query(OrderQueryBuilder orderQueryBuilder, ResultListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        String responseStr = HttpClientUtils.post2(ConfigurationUtils.getConsumerFinanceOrderQueryUrl(), orderQueryBuilder.encryptBuild());
        LOGGER.info("OrderQueryExecuter query responseStr:[" + responseStr + "]");
        JSONObject responseData = JSONObject.parseObject(responseStr, Feature.SortFeidFastMatch);
        responseData = CipherWrapper.decryptWrap(responseData);
        this.verifyHmacOrder(responseData);
        String status = responseData.getString(Constants.STATUS);
        if ("LOANED".equals(status)) {
            listener.success(responseData);
        } else if (Constants.FAILED.equals(status) || Constants.CANCEL.equals(status)) {
            listener.failure(responseData);
        } else if (Constants.INIT.equals(status)) {
            listener.pending(responseData);
        } else {
            throw new ResponseException(responseData);
        }
    }
}

