/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.cp.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.cp.entity.HotelInfo;
import com.upay.sdk.cp.entity.OtherInfo;
import com.upay.sdk.cp.entity.ProductDetail;
import com.upay.sdk.cp.entity.StudyAbroadInfo;
import com.upay.sdk.cp.entity.TicketInfo;
import com.upay.sdk.entity.Payer;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String settlementCurrency;
    private String orderAmount;
    private String orderCurrency;
    private String notifyUrl;
    private String callbackUrl;
    private String isDirect;
    private String subject;
    private String paymentModeCode;
    private String clientIp;
    private String authCode;
    private String openId;
    private String appId;
    private String mccStr;
    private String forUse;
    private String remark;
    private HotelInfo hotelInfo;
    private TicketInfo ticketInfo;
    private StudyAbroadInfo studyAbroadInfo;
    private OtherInfo otherInfo;
    private List<ProductDetail> goodstrades = new LinkedList<ProductDetail>();
    private Payer payer;
    private String timeout;
    private String referType;
    private String description;

    public OrderBuilder setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public OrderBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public OrderBuilder setForUse(String forUse) {
        this.forUse = forUse;
        return this;
    }

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setOrderAmount(String orderAmount) {
        this.orderAmount = orderAmount;
        return this;
    }

    public OrderBuilder setOrderCurrency(String orderCurrency) {
        this.orderCurrency = orderCurrency;
        return this;
    }

    public OrderBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public OrderBuilder setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public OrderBuilder setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public OrderBuilder setPaymentModeCode(String paymentModeCode) {
        this.paymentModeCode = paymentModeCode;
        return this;
    }

    public OrderBuilder setAuthCode(String authCode) {
        this.authCode = authCode;
        return this;
    }

    public OrderBuilder setOpenId(String openId) {
        this.openId = openId;
        return this;
    }

    public OrderBuilder setPayer(Payer payer) {
        this.payer = payer;
        return this;
    }

    public OrderBuilder addProductDetail(ProductDetail productDetail) {
        this.goodstrades.add(productDetail);
        return this;
    }

    public OrderBuilder setClientIp(String clientIp) {
        this.clientIp = clientIp;
        return this;
    }

    public OrderBuilder setTimeout(String timeout) {
        this.timeout = timeout;
        return this;
    }

    public OrderBuilder setSettlementCurrency(String settlementCurrency) {
        this.settlementCurrency = settlementCurrency;
        return this;
    }

    public OrderBuilder setIsDirect(String isDirect) {
        this.isDirect = isDirect;
        return this;
    }

    public OrderBuilder setMccStr(String mccStr) {
        this.mccStr = mccStr;
        return this;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public OrderBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public OrderBuilder setReferType(String referType) {
        this.referType = referType;
        return this;
    }

    public String getMerchantId() {
        return this.merchantId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getSettlementCurrency() {
        return this.settlementCurrency;
    }

    public String getOrderAmount() {
        return this.orderAmount;
    }

    public String getOrderCurrency() {
        return this.orderCurrency;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getIsDirect() {
        return this.isDirect;
    }

    public String getPaymentModeCode() {
        return this.paymentModeCode;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getAuthCode() {
        return this.authCode;
    }

    public String getOpenId() {
        return this.openId;
    }

    public String getMccStr() {
        return this.mccStr;
    }

    public String getForUse() {
        return this.forUse;
    }

    public String getRemark() {
        return this.remark;
    }

    public List<ProductDetail> getGoodstrades() {
        return this.goodstrades;
    }

    public Payer getPayer() {
        return this.payer;
    }

    public String getTimeout() {
        return this.timeout;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }

    public HotelInfo getHotelInfo() {
        return this.hotelInfo;
    }

    public void setHotelInfo(HotelInfo hotelInfo) {
        this.hotelInfo = hotelInfo;
    }

    public TicketInfo getTicketInfo() {
        return this.ticketInfo;
    }

    public void setTicketInfo(TicketInfo ticketInfo) {
        this.ticketInfo = ticketInfo;
    }

    public StudyAbroadInfo getStudyAbroadInfo() {
        return this.studyAbroadInfo;
    }

    public void setStudyAbroadInfo(StudyAbroadInfo studyAbroadInfo) {
        this.studyAbroadInfo = studyAbroadInfo;
    }

    public OtherInfo getOtherInfo() {
        return this.otherInfo;
    }

    public void setOtherInfo(OtherInfo otherInfo) {
        this.otherInfo = otherInfo;
    }

    public String getSubject() {
        return this.subject;
    }
}

