/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.customs.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.entity.CustomsInfo;
import com.upay.sdk.entity.CustomsPayer;
import com.upay.sdk.exception.UnknownException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class OrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String paySerialNumber;
    private String notifyUrl;
    private CustomsPayer payer;
    private List<CustomsInfo> customsInfos = new LinkedList<CustomsInfo>();

    public OrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public OrderBuilder setPaySerialNumber(String paySerialNumber) {
        this.paySerialNumber = paySerialNumber;
        return this;
    }

    public OrderBuilder setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public void setCustomsInfos(List<CustomsInfo> customsInfos) {
        this.customsInfos = customsInfos;
    }

    public OrderBuilder addCustomsInfo(CustomsInfo customsInfo) {
        this.customsInfos.add(customsInfo);
        return this;
    }

    public OrderBuilder setPayer(CustomsPayer payer) {
        this.payer = payer;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.paySerialNumber)) {
            json.put("paySerialNumber", (Object)this.paySerialNumber);
        }
        if (StringUtils.isNotBlank((CharSequence)this.notifyUrl)) {
            json.put("notifyUrl", (Object)this.notifyUrl);
        }
        json.put("payer", (Object)this.payer);
        json.put("customsInfos", (Object)this.customsInfos);
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.paySerialNumber, (String)"")).append(StringUtils.defaultString((String)this.notifyUrl, (String)""));
        if (this.payer != null) {
            hmacSource.append(StringUtils.defaultString((String)this.payer.getPayerName())).append(StringUtils.defaultString((String)this.payer.getIdNum())).append(StringUtils.defaultString((String)this.payer.getPhoneNum()));
        }
        if (this.customsInfos != null) {
            for (CustomsInfo customsInfo : this.customsInfos) {
                hmacSource.append(StringUtils.defaultString((String)customsInfo.getCustomsChannel())).append(ObjectUtils.defaultIfNull((Object)customsInfo.getAmount(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getFreight(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getGoodsAmount(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getTax(), (Object)"")).append(ObjectUtils.defaultIfNull((Object)customsInfo.getInsuredAmount(), (Object)"")).append(StringUtils.defaultString((String)customsInfo.getMerchantCommerceName())).append(StringUtils.defaultString((String)customsInfo.getMerchantCommerceCode())).append(StringUtils.defaultString((String)customsInfo.getStoreHouse())).append(StringUtils.defaultString((String)customsInfo.getCustomsCode())).append(StringUtils.defaultString((String)customsInfo.getFunctionCode())).append(StringUtils.defaultString((String)customsInfo.getBusinessType())).append(StringUtils.defaultString((String)customsInfo.getDxpid()));
            }
        }
        System.out.println("===========" + hmacSource.toString());
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

