/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.declaration.v_3.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public final class SettlementOrderBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String subMerchantId;
    private String settleMode;
    private String cycleType;
    private String cycleData;
    private String minAmount;
    private String recBankAccountNo;
    private String recName;
    private String recIdCardNum;
    private String recBankCode;
    private String recBranchBankName;
    private String recProvinceCode;
    private String recCityCode;
    private String recAccountType;
    private String recBankPhoneNum;

    public SettlementOrderBuilder setRecBankPhoneNum(String recBankPhoneNum) {
        this.recBankPhoneNum = StringUtils.isBlank((CharSequence)recBankPhoneNum) ? null : recBankPhoneNum;
        return this;
    }

    public SettlementOrderBuilder(String merchantId) {
        this.merchantId = merchantId;
    }

    public SettlementOrderBuilder setMerchantId(String merchantId) {
        this.merchantId = StringUtils.isBlank((CharSequence)merchantId) ? null : merchantId;
        return this;
    }

    public SettlementOrderBuilder setRequestId(String requestId) {
        this.requestId = StringUtils.isBlank((CharSequence)requestId) ? null : requestId;
        return this;
    }

    public SettlementOrderBuilder setSubMerchantId(String subMerchantId) {
        this.subMerchantId = StringUtils.isBlank((CharSequence)subMerchantId) ? null : subMerchantId;
        return this;
    }

    public SettlementOrderBuilder setSettleMode(String settleMode) {
        this.settleMode = StringUtils.isBlank((CharSequence)settleMode) ? null : settleMode;
        return this;
    }

    public SettlementOrderBuilder setCycleType(String cycleType) {
        this.cycleType = StringUtils.isBlank((CharSequence)cycleType) ? null : cycleType;
        return this;
    }

    public SettlementOrderBuilder setCycleData(String cycleData) {
        this.cycleData = StringUtils.isBlank((CharSequence)cycleData) ? null : cycleData;
        return this;
    }

    public SettlementOrderBuilder setMinAmount(String minAmount) {
        this.minAmount = StringUtils.isBlank((CharSequence)minAmount) ? null : minAmount;
        return this;
    }

    public SettlementOrderBuilder setRecBankAccountNo(String recBankAccountNo) {
        this.recBankAccountNo = StringUtils.isBlank((CharSequence)recBankAccountNo) ? null : recBankAccountNo;
        return this;
    }

    public SettlementOrderBuilder setRecName(String recName) {
        this.recName = StringUtils.isBlank((CharSequence)recName) ? null : recName;
        return this;
    }

    public SettlementOrderBuilder setRecIdCardNum(String recIdCardNum) {
        this.recIdCardNum = StringUtils.isBlank((CharSequence)recIdCardNum) ? null : recIdCardNum;
        return this;
    }

    public SettlementOrderBuilder setRecBankCode(String recBankCode) {
        this.recBankCode = StringUtils.isBlank((CharSequence)recBankCode) ? null : recBankCode;
        return this;
    }

    public SettlementOrderBuilder setRecBranchBankName(String recBranchBankName) {
        this.recBranchBankName = StringUtils.isBlank((CharSequence)recBranchBankName) ? null : recBranchBankName;
        return this;
    }

    public SettlementOrderBuilder setRecProvinceCode(String recProvinceCode) {
        this.recProvinceCode = StringUtils.isBlank((CharSequence)recProvinceCode) ? null : recProvinceCode;
        return this;
    }

    public SettlementOrderBuilder setRecCityCode(String recCityCode) {
        this.recCityCode = StringUtils.isBlank((CharSequence)recCityCode) ? null : recCityCode;
        return this;
    }

    public SettlementOrderBuilder setRecAccountType(String recAccountType) {
        this.recAccountType = StringUtils.isBlank((CharSequence)recAccountType) ? null : recAccountType;
        return this;
    }

    public JSONObject build() {
        JSONObject json = super.build(this.merchantId);
        if (StringUtils.isNotBlank((CharSequence)this.merchantId)) {
            json.put("merchantId", (Object)this.merchantId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.requestId)) {
            json.put("requestId", (Object)this.requestId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.subMerchantId)) {
            json.put("subMerchantId", (Object)this.subMerchantId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.settleMode)) {
            json.put("settleMode", (Object)this.settleMode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cycleType)) {
            json.put("cycleType", (Object)this.cycleType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cycleData)) {
            json.put("cycleData", (Object)this.cycleData);
        }
        if (StringUtils.isNotBlank((CharSequence)this.minAmount)) {
            json.put("minAmount", (Object)this.minAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)this.recBankAccountNo)) {
            json.put("recBankAccountNo", (Object)this.recBankAccountNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.recName)) {
            json.put("recName", (Object)this.recName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.recIdCardNum)) {
            json.put("recIdCardNum", (Object)this.recIdCardNum);
        }
        if (StringUtils.isNotBlank((CharSequence)this.recBankCode)) {
            json.put("recBankCode", (Object)this.recBankCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.recBranchBankName)) {
            json.put("recBranchBankName", (Object)this.recBranchBankName);
        }
        if (StringUtils.isNotBlank((CharSequence)this.recProvinceCode)) {
            json.put("recProvinceCode", (Object)this.recProvinceCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.recCityCode)) {
            json.put("recCityCode", (Object)this.recCityCode);
        }
        if (StringUtils.isNotBlank((CharSequence)this.recAccountType)) {
            json.put("recAccountType", (Object)this.recAccountType);
        }
        if (StringUtils.isNotBlank((CharSequence)this.recBankPhoneNum)) {
            json.put("recBankPhoneNum", (Object)this.recBankPhoneNum);
        }
        json.put("hmac", (Object)this.generateHmac());
        return json;
    }

    private String generateHmac() {
        StringBuilder hmacSource = new StringBuilder();
        hmacSource.append(StringUtils.defaultString((String)this.merchantId)).append(StringUtils.defaultString((String)this.requestId, (String)"")).append(StringUtils.defaultString((String)this.subMerchantId, (String)"")).append(StringUtils.defaultString((String)this.settleMode, (String)"")).append(StringUtils.defaultString((String)this.cycleType, (String)"")).append((String)ObjectUtils.defaultIfNull((Object)this.cycleData, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.minAmount, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.recBankAccountNo, (Object)"")).append(StringUtils.defaultString((String)this.recName, (String)"")).append(StringUtils.defaultString((String)this.recIdCardNum, (String)"")).append(StringUtils.defaultString((String)this.recBankCode, (String)"")).append(StringUtils.defaultString((String)this.recBranchBankName, (String)"")).append(StringUtils.defaultString((String)this.recProvinceCode, (String)"")).append(StringUtils.defaultString((String)this.recCityCode, (String)"")).append((String)ObjectUtils.defaultIfNull((Object)this.recAccountType, (Object)"")).append((String)ObjectUtils.defaultIfNull((Object)this.recBankPhoneNum, (Object)""));
        return SignUtils.signMd5(hmacSource.toString(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject encryptBuild() {
        JSONObject json = super.assembleBuild();
        json.put("hmac", (Object)this.orderGenerateHmac());
        return CipherWrapper.encryptWrap(this.merchantId, json);
    }

    @Override
    protected String orderGenerateHmac() {
        String orderGenerateHmac = super.orderGenerateHmac();
        String hmacKey = ConfigurationUtils.getHmacKey(this.merchantId);
        return SignUtils.signMd5(orderGenerateHmac, hmacKey);
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

