/*
 * Decompiled with CFR 0.152.
 */
package com.upay.sdk.ert.v_3.v2.builder;

import com.alibaba.fastjson15.JSONObject;
import com.upay.sdk.CipherWrapper;
import com.upay.sdk.ConfigurationUtils;
import com.upay.sdk.RSAUtils;
import com.upay.sdk.SignUtils;
import com.upay.sdk.builder.BuilderSupport;
import com.upay.sdk.exception.UnknownException;

public final class UserSignUpBuilder
extends BuilderSupport {
    private String merchantId;
    private String requestId;
    private String userName;
    private String shortName;
    private String email;
    private String businessAddress;
    private String bankCardNo;
    private String name;
    private String idCardNum;
    private String phone;
    private String province;
    private String city;
    private String idCardImgFrontUrl;
    private String idCardImgBackUrl;
    private String bankCardImgUrl;
    private String holdCardImgUrl;
    private String profession;
    private String ip;
    private String mac;

    public UserSignUpBuilder setMerchantId(String merchantId) {
        this.merchantId = merchantId;
        return this;
    }

    public UserSignUpBuilder setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public UserSignUpBuilder setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public UserSignUpBuilder setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public UserSignUpBuilder setEmail(String email) {
        this.email = email;
        return this;
    }

    public UserSignUpBuilder setBusinessAddress(String businessAddress) {
        this.businessAddress = businessAddress;
        return this;
    }

    public UserSignUpBuilder setBankCardNo(String bankCardNo) {
        this.bankCardNo = bankCardNo;
        return this;
    }

    public UserSignUpBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public UserSignUpBuilder setIdCardNum(String idCardNum) {
        this.idCardNum = idCardNum;
        return this;
    }

    public UserSignUpBuilder setPhone(String phone) {
        this.phone = phone;
        return this;
    }

    public UserSignUpBuilder setProvince(String province) {
        this.province = province;
        return this;
    }

    public UserSignUpBuilder setCity(String city) {
        this.city = city;
        return this;
    }

    public UserSignUpBuilder setIdCardImgFrontUrl(String idCardImgFrontUrl) {
        this.idCardImgFrontUrl = idCardImgFrontUrl;
        return this;
    }

    public UserSignUpBuilder setIdCardImgBackUrl(String idCardImgBackUrl) {
        this.idCardImgBackUrl = idCardImgBackUrl;
        return this;
    }

    public UserSignUpBuilder setBankCardImgUrl(String bankCardImgUrl) {
        this.bankCardImgUrl = bankCardImgUrl;
        return this;
    }

    public UserSignUpBuilder setHoldCardImgUrl(String holdCardImgUrl) {
        this.holdCardImgUrl = holdCardImgUrl;
        return this;
    }

    public UserSignUpBuilder setProfession(String profession) {
        this.profession = profession;
        return this;
    }

    public UserSignUpBuilder setIp(String ip) {
        this.ip = ip;
        return this;
    }

    public UserSignUpBuilder setMac(String mac) {
        this.mac = mac;
        return this;
    }

    @Override
    protected String orderGenerateHmac() {
        return SignUtils.signMd5(super.orderGenerateHmac(), ConfigurationUtils.getHmacKey(this.merchantId));
    }

    public JSONObject bothEncryptBuild() {
        JSONObject json = super.assembleBuild();
        try {
            json.put("hmac", (Object)this.bothOrderGenerateHmac());
        }
        catch (Exception e) {
            throw new UnknownException(e);
        }
        return CipherWrapper.bothEncryptWrap(this.merchantId, json);
    }

    protected byte[] bothOrderGenerateHmac() throws Exception {
        return RSAUtils.encryptSHA(super.orderGenerateHmac().getBytes("UTF-8"));
    }
}

